/*
 * Decompiled with CFR 0.152.
 */
package irrigation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JAMSComponentDescription(title="IrrigationDam_PumpFromGroundwater", author="Sven Kralisch", description="TBD", date="2020-09-07", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class IrrigationDam_PumpFromGroundwater
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current date")
    public Attribute.Calendar date;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hrus")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of reaches")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Dam capacity", defaultValue="0", unit="m\u00b3", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double damCapacity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Pumping capactiy from groundwater", defaultValue="0", unit="m\u00b3", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double groundwaterPump;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian day at which pumping from groundwater starts", defaultValue="1", lowerBound=0.0, upperBound=366.0)
    public Attribute.Double groundwaterStart;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian day at which pumping from groundwater ends", defaultValue="1", lowerBound=0.0, upperBound=366.0)
    public Attribute.Double groundwaterEnd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of sub-basin attribute", defaultValue="subbasin")
    public Attribute.String subbasinAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of groundwater attribute", defaultValue="actRG1;actRG2")
    public Attribute.StringArray groundwaterAttributeNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Adaptation factor for reducing the water that is allowed to be pumped", defaultValue="1", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double adaptationFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Current dam storage", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double damStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Water volume pumped at current time step", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double pumpVolume;
    private Map<Attribute.Entity, List<Attribute.Entity>> reach2hruMap = new HashMap<Attribute.Entity, List<Attribute.Entity>>();

    public void init() {
        HashMap<Long, Attribute.Entity> reachMap = new HashMap<Long, Attribute.Entity>();
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            reachMap.put(reach.getId(), reach);
        }
        for (Attribute.Entity hru : this.hrus.getEntities()) {
            double subbasinID = hru.getDouble(this.subbasinAttributeName.getValue());
            Attribute.Entity reach = (Attribute.Entity)reachMap.get((long)subbasinID);
            List<Attribute.Entity> hruList = this.reach2hruMap.get(reach);
            if (hruList == null) {
                hruList = new ArrayList<Attribute.Entity>();
                this.reach2hruMap.put(reach, hruList);
            }
            hruList.add(hru);
        }
    }

    public void run() {
        double availableCapacity = this.damCapacity.getValue() * 1000.0 - this.damStorage.getValue();
        double pumpedWater = 0.0;
        if (availableCapacity <= 0.0) {
            this.pumpVolume.setValue(0.0);
            return;
        }
        int julDay = this.date.getValue().get(6);
        double gStart = this.groundwaterStart.getValue();
        double gEnd = this.groundwaterEnd.getValue();
        double gJD = julDay;
        if (gStart > gEnd) {
            gEnd = 366.0 + gEnd;
            gJD = 366.0 + gJD;
        }
        if (gJD >= gStart && gJD <= gEnd) {
            Attribute.Entity reach = this.reaches.getCurrent();
            List<Attribute.Entity> hrus = this.reach2hruMap.get(reach);
            double totalIn = 0.0;
            for (String groundwaterAttributeName : this.groundwaterAttributeNames.getValue()) {
                for (Attribute.Entity hru : hrus) {
                    totalIn += hru.getDouble(groundwaterAttributeName);
                }
            }
            double totalAvail = Math.min(totalIn *= this.adaptationFactor.getValue(), this.groundwaterPump.getValue() * 1000.0);
            double frac = Math.min(availableCapacity / totalAvail, 1.0);
            double frac1 = 1.0 - frac;
            for (String groundwaterAttributeName : this.groundwaterAttributeNames.getValue()) {
                for (Attribute.Entity hru : hrus) {
                    hru.setDouble(groundwaterAttributeName, frac1 * hru.getDouble(groundwaterAttributeName));
                }
            }
            pumpedWater = totalAvail * frac;
            this.damStorage.setValue(this.damStorage.getValue() + pumpedWater);
        }
        this.pumpVolume.setValue(pumpedWater);
    }
}

