/*
 * Decompiled with CFR 0.152.
 */
package irrigation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.HashMap;
import java.util.Map;

@JAMSComponentDescription(title="IrrigationDam_ApplicationAspersion", author="Sven Kralisch", description="TBD", date="2020-09-10", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class IrrigationDam_ApplicationAspersion2
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Subbasin ID")
    public Attribute.Double subbasinID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="All reaches")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="The subbasin reach")
    public Attribute.Entity subbasinReach;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state var actual MPS", unit="L")
    public Attribute.Double actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="actual ET", unit="L")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="potential ET", unit="L")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="correction factor for irrigation applied [0,1]", defaultValue="1")
    public Attribute.Double correctionFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of reach dam storage attribute", defaultValue="damStorage")
    public Attribute.String damStorageAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Applied irrigation volume", unit="L")
    public Attribute.Double irrigationApplied;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Irrigation demand", unit="L")
    public Attribute.Double demand;
    Map<Long, Attribute.Entity> reachMap = new HashMap<Long, Attribute.Entity>();

    public void init() {
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            this.reachMap.put(reach.getId(), reach);
        }
    }

    public void initAll() {
        Attribute.Entity reach = this.reachMap.get((long)this.subbasinID.getValue());
        this.subbasinReach.setValue(reach.getValue());
        this.subbasinReach.setId(reach.getId());
    }

    public void run() {
        double demand = this.potET.getValue() - this.actET.getValue();
        double storage = this.subbasinReach.getDouble(this.damStorageAttributeName.getValue());
        double irrigation = Math.min(demand, storage);
        this.actMPS.setValue(this.actMPS.getValue() + (irrigation *= this.correctionFactor.getValue()));
        this.subbasinReach.setDouble(this.damStorageAttributeName.getValue(), storage - irrigation);
        this.irrigationApplied.setValue(irrigation);
        this.demand.setValue(demand);
    }

    public void cleanup() {
    }
}

