/*
 * Decompiled with CFR 0.152.
 */
package irrigation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="", author="Sven Kralisch", description="Apply irrigation on an HRU based on available water", date="2015-08-13", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class IrrigationApplicationAspersion_Melanie
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Water available for irrigation", unit="l")
    public Attribute.Double irrigationWater;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Added water for irrigation", unit="l")
    public Attribute.Double irrigationTotal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU net Rain", unit="mm")
    public Attribute.Double netRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU area", unit="m\u00b2")
    public Attribute.Double area;

    public void run() {
        this.irrigationTotal.setValue(0.0);
        double irrigationInMM = this.irrigationWater.getValue() / this.area.getValue();
        this.netRain.setValue(this.netRain.getValue() + irrigationInMM);
        this.irrigationTotal.setValue(this.irrigationWater.getValue());
        this.irrigationWater.setValue(0.0);
    }
}

