/*
 * Decompiled with CFR 0.152.
 */
package io;

import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.unijena.j2k.J2KFunctions;
import org.unijena.j2k.io.StandardEntityReader;

@JAMSComponentDescription(title="StandardEntityReaderDualTopo", author="Sven Kralisch", description="This is a modification of the StandardEntityReader whichadds a two-directional linkage between entities", date="2015-07-08", version="1.0")
public class StandardEntityReaderUpstreamTopo
extends StandardEntityReader {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the upstream catchment relation")
    public Attribute.String upStreamCatchmentAttribute;
    ArrayList<Attribute.Entity> hruList;
    ArrayList<Attribute.Entity> reachList;
    HashMap<Double, Attribute.Entity> hruMap;
    HashMap<Double, Attribute.Entity> reachMap;
    Attribute.Entity nullEntity;
    Attribute.Entity defaultRootReach;
    HashMap<Attribute.Entity, List<Attribute.Entity>> children;

    @Override
    public void init() {
        this.defaultRootReach = null;
        this.getModel().getRuntime().println("Reading spatial model entities...", 2);
        this.hruList = J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.hruFileName.getValue()), this.getModel());
        for (Attribute.Entity e : this.hruList) {
            try {
                e.setId((long)e.getDouble(this.hruIDAttribute.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K HRU parameter file (" + this.hruFileName.getValue() + ")!");
            }
        }
        this.reachList = J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.reachFileName.getValue()), this.getModel());
        for (Attribute.Entity e : this.reachList) {
            try {
                e.setId((long)e.getDouble(this.reachIDAttribute.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K reach parameter file (" + this.reachFileName.getValue() + ")!");
            }
        }
        this.createEntityMaps();
        this.createTopology();
        this.createChildrenMap();
        this.getModel().getRuntime().println("Model entities read successfully. This resulted in " + this.hruList.size() + " HRUs / " + this.reachList.size() + " reaches overall.", 1);
        this.createEntityCollections();
        this.createUpStreamCollections();
        this.getModel().getRuntime().println("Model entities ordered and subsetted successfully. This resulted in " + this.hrus.getEntities().size() + " HRUs / " + this.reaches.getEntities().size() + " reaches.", 1);
    }

    private void createUpStreamCollections() {
        for (Attribute.Entity hru : this.hrus.getEntities()) {
            Attribute.EntityCollection subCatchment;
            Attribute.Entity reach = (Attribute.Entity)hru.getObject(this.hru2reachAttribute.getValue());
            if (reach == this.nullEntity) continue;
            List catchmentList = this.getSubtreeList(hru, this.children);
            ArrayList<Attribute.Entity> hl = new ArrayList<Attribute.Entity>();
            for (int i = catchmentList.size() - 1; i >= 0; --i) {
                Attribute.Entity e = (Attribute.Entity)catchmentList.get(i);
                hl.add(e);
            }
            if (reach.existsAttribute(this.upStreamCatchmentAttribute.getValue())) {
                subCatchment = (Attribute.EntityCollection)reach.getObject(this.upStreamCatchmentAttribute.getValue());
            } else {
                subCatchment = this.getModel().getRuntime().getDataFactory().createEntityCollection();
                reach.setObject(this.upStreamCatchmentAttribute.getValue(), (Object)subCatchment);
            }
            List existingList = subCatchment.getEntities();
            existingList.addAll(hl);
        }
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            if (reach.existsAttribute(this.upStreamCatchmentAttribute.getValue())) continue;
            this.getModel().getRuntime().sendInfoMsg("No upstream basin for reach " + reach.getId());
            Attribute.EntityCollection subCatchment = this.getModel().getRuntime().getDataFactory().createEntityCollection();
            reach.setObject(this.upStreamCatchmentAttribute.getValue(), (Object)subCatchment);
        }
    }

    @Override
    protected boolean cycleCheck(Attribute.Entity node, Stack<Attribute.Entity> searchStack, HashSet<Long> closedList, HashSet<Long> visitedList) {
        if (searchStack.contains(node)) {
            int index = searchStack.indexOf(node);
            String cyc_output = new String();
            for (int i = index; i < searchStack.size(); ++i) {
                cyc_output = cyc_output + ((Attribute.Entity)searchStack.get(i)).getId() + " ";
            }
            this.getModel().getRuntime().println("Found circle with ids:" + cyc_output);
            return true;
        }
        if (closedList.contains(node.getId())) {
            return false;
        }
        visitedList.add(node.getId());
        Attribute.Entity child_node = (Attribute.Entity)node.getObject(this.hru2hruAttribute.getValue());
        if (child_node != null && child_node.isEmpty()) {
            child_node = null;
        }
        if (child_node != null) {
            searchStack.push(node);
            boolean result = this.cycleCheck(child_node, searchStack, closedList, visitedList);
            searchStack.pop();
            return result;
        }
        return false;
    }

    @Override
    protected boolean cycleCheck() {
        HashSet<Long> closedList = new HashSet<Long>();
        HashSet<Long> visitedList = new HashSet<Long>();
        this.getModel().getRuntime().println("Cycle checking...");
        Iterator<Attribute.Entity> hruIterator = this.hruList.iterator();
        boolean result = false;
        while (hruIterator.hasNext()) {
            Attribute.Entity start_node = hruIterator.next();
            if (closedList.contains(start_node.getId())) continue;
            if (this.cycleCheck(start_node, new Stack<Attribute.Entity>(), closedList, visitedList)) {
                result = true;
            }
            closedList.addAll(visitedList);
            visitedList.clear();
        }
        return result;
    }

    private void createChildrenMap() {
        List<Attribute.Entity> l;
        Attribute.Entity parentNode;
        this.children = new HashMap();
        for (Attribute.Entity node : this.hruList) {
            parentNode = (Attribute.Entity)node.getObject(this.hru2hruAttribute.getValue());
            if (parentNode != this.nullEntity) {
                l = this.children.get(parentNode);
                if (l == null) {
                    l = new ArrayList<Attribute.Entity>();
                    this.children.put(parentNode, l);
                }
                l.add(node);
            }
            if ((parentNode = (Attribute.Entity)node.getObject(this.hru2reachAttribute.getValue())) == this.nullEntity) continue;
            l = this.children.get(parentNode);
            if (l == null) {
                l = new ArrayList<Attribute.Entity>();
                this.children.put(parentNode, l);
            }
            l.add(node);
        }
        for (Attribute.Entity node : this.reachList) {
            parentNode = (Attribute.Entity)node.getObject(this.reach2reachAttribute.getValue());
            if (parentNode == this.nullEntity) continue;
            l = this.children.get(parentNode);
            if (l == null) {
                l = new ArrayList<Attribute.Entity>();
                this.children.put(parentNode, l);
            }
            l.add(node);
        }
    }

    private void createEntityCollections() {
        Attribute.Entity root;
        if (this.subcatchmentReachID.getValue() != -1.0) {
            root = this.reachMap.get(this.subcatchmentReachID.getValue());
            if (root != null) {
                root.setObject(this.reach2reachAttribute.getValue(), (Object)this.nullEntity);
            } else {
                root = this.defaultRootReach;
                this.getModel().getRuntime().println("Subbasin with id " + this.subcatchmentReachID.getValue() + " does not exist! Using default outlet.");
            }
        } else {
            root = this.defaultRootReach;
        }
        List catchmentList = this.getSubtreeList(root, this.children);
        ArrayList<Attribute.Entity> hl = new ArrayList<Attribute.Entity>();
        ArrayList<Attribute.Entity> rl = new ArrayList<Attribute.Entity>();
        HashSet<Attribute.Entity> reachSet = new HashSet<Attribute.Entity>();
        for (Attribute.Entity e : this.reachMap.values()) {
            reachSet.add(e);
        }
        for (int i = catchmentList.size() - 1; i >= 0; --i) {
            Attribute.Entity e;
            e = (Attribute.Entity)catchmentList.get(i);
            if (reachSet.contains(e)) {
                rl.add(e);
                continue;
            }
            hl.add(e);
        }
        this.hrus.setEntities(hl);
        this.reaches.setEntities(rl);
    }

    private List getSubtreeList(Attribute.Entity node, HashMap<Attribute.Entity, List<Attribute.Entity>> children) {
        ArrayList<Attribute.Entity> treeList = new ArrayList<Attribute.Entity>();
        treeList.add(node);
        List<Attribute.Entity> l = children.get(node);
        if (l != null) {
            for (Attribute.Entity e : l) {
                treeList.addAll(this.getSubtreeList(e, children));
            }
        }
        return treeList;
    }

    private void createEntityMaps() {
        this.hruMap = new HashMap();
        this.reachMap = new HashMap();
        for (Attribute.Entity e : this.hruList) {
            double id = e.getId();
            if (!this.hruMap.containsKey(id)) {
                this.hruMap.put(id, e);
                continue;
            }
            this.getModel().getRuntime().sendErrorMsg("Found duplicate HRU-ID (" + e.getId() + "). This may cause errors!");
        }
        for (Attribute.Entity e : this.reachList) {
            double id = e.getId();
            if (!this.reachMap.containsKey(id)) {
                this.reachMap.put(id, e);
                continue;
            }
            this.getModel().getRuntime().sendErrorMsg("Found duplicate reach-ID (" + e.getId() + "). This may cause errors!");
        }
        this.nullEntity = this.getModel().getRuntime().getDataFactory().createEntity();
        this.hruMap.put(0.0, this.nullEntity);
        this.reachMap.put(0.0, this.nullEntity);
    }

    @Override
    protected void createTopology() {
        Attribute.Entity toReach;
        for (Attribute.Entity e : this.hruList) {
            Attribute.Entity toPoly = this.hruMap.get(e.getDouble(this.hru2hruAttribute.getValue()));
            toReach = this.reachMap.get(e.getDouble(this.hru2reachAttribute.getValue()));
            if (toPoly == null || toReach == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological neighbour for HRU with ID " + e.getId() + " could not be found. This may cause errors!");
            } else if (toPoly == this.nullEntity && toReach == this.nullEntity) {
                this.getModel().getRuntime().sendInfoMsg("The HRU with ID " + e.getId() + " drains nowhere. This may cause errors!");
            }
            e.setObject(this.hru2hruAttribute.getValue(), (Object)toPoly);
            e.setObject(this.hru2reachAttribute.getValue(), (Object)toReach);
        }
        for (Attribute.Entity e : this.reachList) {
            toReach = this.reachMap.get(e.getDouble(this.reach2reachAttribute.getValue()));
            if (toReach == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological neighbour for reach with ID " + e.getId() + " could not be found. This may cause errors!");
            } else if (toReach == this.nullEntity) {
                if (this.defaultRootReach != null) {
                    this.getModel().getRuntime().sendInfoMsg("The river network has more than one outlet! This may cause errors! ID of first outlet is: " + this.defaultRootReach.getId() + " and the second outlet is: " + toReach.getId());
                }
                this.defaultRootReach = e;
            }
            e.setObject(this.reach2reachAttribute.getValue(), (Object)toReach);
        }
        if (this.getModel().getRuntime().getDebugLevel() >= 3) {
            if (this.cycleCheck()) {
                this.getModel().getRuntime().sendHalt("HRUs --> cycle found ... :( ");
            } else {
                this.getModel().getRuntime().println("HRUs --> no cycle found");
            }
        }
    }

    @Override
    protected void createOrderedList(Attribute.EntityCollection col, String asso) {
        int i;
        ArrayList<Attribute.Entity> newList = new ArrayList<Attribute.Entity>();
        HashMap<Object, Integer> depthMap = new HashMap<Object, Integer>();
        boolean mapChanged = true;
        Iterator hruIterator = col.getEntities().iterator();
        while (hruIterator.hasNext()) {
            depthMap.put(hruIterator.next(), new Integer(0));
        }
        int maxDepth = 0;
        while (mapChanged) {
            mapChanged = false;
            for (Attribute.Entity e : col.getEntities()) {
                Attribute.Entity f = (Attribute.Entity)e.getObject(asso);
                if (f == null) {
                    this.getModel().getRuntime().println("warning hru with id:" + e.getId() + " has no receiver");
                }
                if (f != null && f.isEmpty()) {
                    f = null;
                }
                if (f == null) continue;
                Integer eDepth = (Integer)depthMap.get(e);
                Integer fDepth = (Integer)depthMap.get(f);
                if (fDepth > eDepth) continue;
                depthMap.put(f, new Integer(eDepth + 1));
                mapChanged = true;
            }
        }
        maxDepth = 0;
        for (Attribute.Entity e : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity e : col.getEntities()) {
            int depth = (Integer)depthMap.get(e);
            ((ArrayList)alList.get(depth)).add(e);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (Attribute.Entity e : (ArrayList)alList.get(i)) {
                newList.add(e);
            }
        }
        col.setEntities(newList);
    }
}

