/*
 * Decompiled with CFR 0.152.
 */
package flooding;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.Collections;

@JAMSComponentDescription(title="SubbasinInnundation", author="Sven Kralisch & Markus Meinhardt", description="iterate over (elevation-sorted) HRUs and distribute reach water; needs: Array list from StandardEntityReaderUpstreamTopo", date="2015-12-11", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class SubbasinFlooding
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The HRUs that drain into the reach")
    public Attribute.EntityCollection subbasinHRUs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The name of the HRU's elevation attribute", defaultValue="elevation", unit="m")
    public Attribute.String elevationAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The name of the HRU's elevation attribute", defaultValue="area", unit="sq m")
    public Attribute.String areaAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The name of the HRU's flood volume attribute that should be used for flooding", defaultValue="floodVolume", unit="liter")
    public Attribute.String floodVolumeAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Runoff components of the reach that should be used for flooding", unit="liter")
    public Attribute.Double[] runoffComponents;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="reach width attribute", unit="m")
    public Attribute.Double reachWidth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="reach length attribute", unit="m")
    public Attribute.Double reachLength;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="reach height attribute", unit="m")
    public Attribute.Double reachHeight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="reach deepening attribute", unit="m")
    public Attribute.Double deepening;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Flood height above reach", unit="m")
    public Attribute.Double floodHeight;

    public void initAll() {
        Collections.sort(this.subbasinHRUs.getEntities(), (e1, e2) -> (int)(e1.getDouble(this.elevationAttributeName.getValue()) - e2.getDouble(this.elevationAttributeName.getValue())));
    }

    public void run() {
        double sum = 0.0;
        double[] proportion = new double[this.runoffComponents.length];
        for (Attribute.Double d : this.runoffComponents) {
            sum += d.getValue();
        }
        int i = 0;
        for (Attribute.Double d : this.runoffComponents) {
            proportion[i++] = d.getValue() / sum;
        }
        double floodLevel = sum / 1000.0 / this.reachLength.getValue() / this.reachWidth.getValue() - this.deepening.getValue();
        if (floodLevel <= 0.0) {
            for (Attribute.Entity e : this.subbasinHRUs.getEntities()) {
                e.setDouble(this.floodVolumeAttributeName.getValue(), 0.0);
            }
            this.floodHeight.setValue(0.0);
            return;
        }
        double floodArea = this.reachLength.getValue() * this.reachWidth.getValue();
        double floodVolume = floodLevel * floodArea;
        this.floodHeight.setValue(floodLevel);
        ArrayList<Attribute.Entity> floodedHRUs = new ArrayList<Attribute.Entity>();
        for (Attribute.Entity e : this.subbasinHRUs.getEntities()) {
            double hruHeight = e.getDouble(this.elevationAttributeName.getValue());
            if (!(floodLevel + this.reachHeight.getValue() > hruHeight)) continue;
            floodLevel = floodVolume / (floodArea += e.getDouble(this.areaAttributeName.getValue()));
            floodedHRUs.add(e);
        }
        double floodVolumeHRUSum = 0.0;
        for (Attribute.Entity e : floodedHRUs) {
            double HRUArea = e.getDouble(this.areaAttributeName.getValue());
            double floodVolumeHRU = HRUArea * floodLevel;
            floodVolumeHRUSum += floodVolumeHRU;
            e.setDouble(this.floodVolumeAttributeName.getValue(), floodVolumeHRU * 1000.0);
        }
        i = 0;
        for (Attribute.Double d : this.runoffComponents) {
            this.runoffComponents[i].setValue(this.runoffComponents[i].getValue() - proportion[i] * floodVolumeHRUSum * 1000.0);
            ++i;
        }
    }

    public void cleanup() {
    }
}

