/*
 * Decompiled with CFR 0.152.
 */
package agriculture;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="FarmDam", author="Sven Kralisch", description="Component for representing impact of farm dams on runoff", date="2016-08-21", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class FarmDam
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Date")
    public Attribute.Calendar currentDate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of current reach")
    public Attribute.Double currentReachID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of reach this dam belongs to")
    public Attribute.Double targetReachID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Runoff components of the reach that should be used for dam filling")
    public Attribute.Double[] flowComponents;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian day at which all the water is consumed", defaultValue="1")
    public Attribute.Integer resetDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Proportion of incoming water that is used for filling", defaultValue="1", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double usageProportion;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Dam capacity", unit="L")
    public Attribute.Double capacity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Current dam volume", unit="L")
    public Attribute.Double volume;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Overall dam storage", unit="L")
    public Attribute.Double overallStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Dam identifyer")
    public Attribute.String damID;

    public void init() {
        this.volume.setValue(0.0);
        this.overallStorage.setValue(0.0);
    }

    public void run() {
        if (this.currentReachID.getValue() != this.targetReachID.getValue()) {
            return;
        }
        int jd = this.currentDate.get(6);
        if (jd == this.resetDay.getValue()) {
            this.overallStorage.setValue(this.overallStorage.getValue() + this.volume.getValue());
            this.volume.setValue(0.0);
        }
        double incomingVolume = 0.0;
        for (Attribute.Double flowComponent : this.flowComponents) {
            incomingVolume += flowComponent.getValue();
        }
        double newStorage = Math.min(incomingVolume * this.usageProportion.getValue(), this.capacity.getValue() - this.volume.getValue());
        this.volume.setValue(this.volume.getValue() + newStorage);
        double fraction = incomingVolume == 0.0 ? 0.0 : newStorage / incomingVolume;
        for (int i = 0; i < this.flowComponents.length; ++i) {
            this.flowComponents[i].setValue(this.flowComponents[i].getValue() * (1.0 - fraction));
        }
    }

    public void cleanup() {
    }
}

