/*
 * Decompiled with CFR 0.152.
 */
package jams.server.entities;

import jams.server.entities.File;
import jams.server.entities.User;
import jams.server.entities.WorkspaceFileAssociation;
import jams.tools.FileTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="workspace")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Workspace.findById", query="SELECT u FROM Workspace u WHERE u.id = :id"), @NamedQuery(name="Workspace.findByUserId", query="SELECT u FROM Workspace u WHERE u.user.id = :id")})
public class Workspace
implements Serializable,
Comparable<Workspace> {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @Size(min=1, max=45)
    @Column(name="name")
    private String name;
    @Temporal(value=TemporalType.DATE)
    @Column(name="creation")
    private Date creation;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ownerID")
    private User user;
    @Basic(optional=true)
    @Column(name="readonly")
    private Integer readOnly;
    @Basic(optional=true)
    @Column(name="workspaceSize")
    private Long workspaceSize;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ancestor")
    private Workspace ancestor;
    @OneToMany(mappedBy="ws", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WorkspaceFileAssociation> files = new ArrayList<WorkspaceFileAssociation>();

    public Workspace() {
        this.init();
    }

    public Workspace(Workspace ws) {
        this.creation = new Date();
        this.files = new ArrayList<WorkspaceFileAssociation>(Arrays.asList(ws.files.toArray(new WorkspaceFileAssociation[0])));
        this.id = 0;
        this.name = ws.getName();
        this.readOnly = ws.readOnly;
        this.user = ws.getUser();
        this.ancestor = ws;
        this.workspaceSize = ws.getWorkspaceSize();
    }

    public Workspace(Integer id) {
        this.id = id;
        this.init();
    }

    public Workspace(Integer id, String name) {
        this.id = id;
        this.name = name;
        this.init();
    }

    private void init() {
        this.setCreationDate(new Date());
    }

    @XmlAttribute
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public Date getCreationDate() {
        return this.creation;
    }

    public void setCreationDate(Date date) {
        this.creation = date;
    }

    public void setUser(User u) {
        this.user = u;
    }

    @XmlElement
    public User getUser() {
        return this.user;
    }

    @XmlAttribute
    public boolean isReadOnly() {
        return this.readOnly != null && this.readOnly > 0;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly ? 1 : 0;
    }

    @XmlElement(name="WorkspaceFileAssociation", type=WorkspaceFileAssociation.class)
    public List<WorkspaceFileAssociation> getFiles() {
        return this.files;
    }

    public void setFiles(List<WorkspaceFileAssociation> files) {
        this.files = files;
        for (WorkspaceFileAssociation wfa : this.getFiles()) {
            wfa.setWorkspace(this);
        }
    }

    public WorkspaceFileAssociation getFile(String path) {
        path = FileTools.normalizePath((String)path);
        for (WorkspaceFileAssociation wfa : this.files) {
            if (!wfa.getPath().equalsIgnoreCase(path)) continue;
            return wfa;
        }
        return null;
    }

    public WorkspaceFileAssociation assignFile(File f, int role, String path) {
        WorkspaceFileAssociation wfa = new WorkspaceFileAssociation(this, f, role, path);
        this.detachFile(path);
        this.files.add(wfa);
        this.updateSize();
        return wfa;
    }

    public File detachFile(String path) {
        path = FileTools.normalizePath((String)path);
        for (WorkspaceFileAssociation wfa : this.files) {
            if (!wfa.getPath().equals(path)) continue;
            this.files.remove(wfa);
            this.updateSize();
            return wfa.getFile();
        }
        return null;
    }

    public void detachAllFiles() {
        while (this.files.size() > 0) {
            WorkspaceFileAssociation wfa = this.files.get(0);
            this.files.remove(wfa);
        }
    }

    @XmlElement
    public Workspace getAncestor() {
        return this.ancestor;
    }

    public void setAncestor(Workspace ancestor) {
        this.ancestor = ancestor;
    }

    private void updateSize() {
        this.workspaceSize = 0L;
        if (this.files == null) {
            return;
        }
        for (WorkspaceFileAssociation wfa : this.files) {
            this.workspaceSize = this.workspaceSize + wfa.getFile().getFileSize();
        }
    }

    @XmlAttribute
    public long getWorkspaceSize() {
        if (this.workspaceSize == null) {
            this.updateSize();
        }
        return this.workspaceSize;
    }

    public void setWorkspaceSize(long size) {
        this.workspaceSize = size;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Workspace)) {
            return false;
        }
        Workspace other = (Workspace)object;
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return "jams.server.entities.Workspace[ id=" + this.id + " ]";
    }

    @Override
    public int compareTo(Workspace o) {
        return Integer.compare(this.getId(), o.getId());
    }
}

