/*
 * Decompiled with CFR 0.152.
 */
package jams.server.entities;

import jams.server.entities.User;
import jams.server.entities.Workspace;
import jams.server.entities.WorkspaceFileAssociation;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="job")
@XmlRootElement
public class Job
implements Serializable,
Comparable<Job> {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ownerID")
    private User owner;
    @Basic(optional=false)
    @Column(name="ownerID", insertable=false, updatable=false)
    private Integer ownerID;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="workspaceID")
    private Workspace workspace;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.PERSIST})
    @JoinColumn(name="modelFileID")
    private WorkspaceFileAssociation modelFile;
    @Basic(optional=false)
    @Size(min=1, max=500)
    @Column(name="server")
    private String server;
    @Basic(optional=true)
    @Column(name="pid")
    private Integer PID;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="startTime")
    private Date startTime;

    public Job() {
    }

    public Job(Integer id) {
        this.id = id;
    }

    public Job(Integer id, User owner, Workspace workspace, WorkspaceFileAssociation modelFile) {
        this.id = id;
        this.owner = owner;
        this.ownerID = owner.getId();
        this.workspace = workspace;
        this.modelFile = modelFile;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public User getOwnerID() {
        return this.owner;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkspaceFileAssociation getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(WorkspaceFileAssociation wfa) {
        this.modelFile = wfa;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPID() {
        if (this.PID == null) {
            return -1;
        }
        return this.PID;
    }

    public void setPID(int PID) {
        this.PID = PID;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return "jams.server.entities.Job[ id=" + this.id + " ]";
    }

    @Override
    public int compareTo(Job o) {
        return Integer.compare(this.getId(), o.getId());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Job)) {
            return false;
        }
        Job job = (Job)o;
        if (job.getId() == null || this.getId() == null) {
            return false;
        }
        return job.getId() == this.getId();
    }
}

