/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.topology;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="SubbasinArea", author="Sven Kralisch", description="Calc the area of the subbasin of a given reach", date="2020-10-25", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class SubbasinStats
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Subbasin HRUs")
    public Attribute.EntityCollection subbasinHRUs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of attribute in subbasin HRUs")
    public Attribute.String valueAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The area attribute of the hrus", defaultValue="area")
    public Attribute.String areaAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Do area weighted means?", defaultValue="False")
    public Attribute.Boolean areaWeighting;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The value of the sub-basin")
    public Attribute.Double value;

    public void run() {
        double v = 0.0;
        double areaSum = 0.0;
        for (Attribute.Entity hru : this.subbasinHRUs.getEntities()) {
            if (this.areaWeighting.getValue()) {
                double area = hru.getDouble(this.areaAttributeName.getValue());
                v += hru.getDouble(this.valueAttributeName.getValue()) * area;
                areaSum += area;
                continue;
            }
            v += hru.getDouble(this.valueAttributeName.getValue());
        }
        if (this.areaWeighting.getValue()) {
            v /= areaSum;
        }
        this.value.setValue(v);
    }
}

