/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.physicalCalculations.HourlySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

@JAMSComponentDescription(title="HourlySolarRadiation", author="Peter Krause", description="Calculates hourly solar radiation from standard climatological measurements")
public class CalcHourlySolarRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="slope aspect correction factor")
    public Attribute.Double actSlAsCf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="fraction of sunshine in one hour", unit="h/h")
    public Attribute.Double sunFrac;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Angstrom factor a", lowerBound=0.0, upperBound=1.0, defaultValue="0.25")
    public Attribute.Double angstrom_a;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Angstrom factor b", lowerBound=0.0, upperBound=1.0, defaultValue="0.5")
    public Attribute.Double angstrom_b;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="hourly solar radiation [MJ/m\u00b2]", unit="MJ / m\u00b2 d")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="extraterrestic radiation [MJ/m\u00b2]", unit="MJ / m\u00b2 d")
    public Attribute.Double actExtRad;

    public void run() {
        double maximumSunshine = HourlySolarRadiationCalculationMethods.calc_HourlyMaxSunshine(this.actExtRad.getValue());
        double solRadiation = SolarRadiationCalculationMethods.calc_SolarRadiation(this.sunFrac.getValue(), maximumSunshine, this.actExtRad.getValue(), this.angstrom_a.getValue(), this.angstrom_b.getValue());
        this.solRad.setValue(solRadiation *= this.actSlAsCf.getValue());
    }
}

