/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.IOException;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;

@JAMSComponentDescription(title="Penman", author="Peter Krause", description="Calculates potential evaporation according to Penman", date="2021-02-18", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version", date="2005-11-24"), @VersionComments.Entry(version="1.0_1", comment="Cleaned up component", date="2021-02-18")})
public class Penman1
extends JAMSComponent {
    public final double CP = 0.001031;
    public final double RSS = 150.0;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable wind")
    public Attribute.Double wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable net radiation")
    public Attribute.Double netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="potential evaporation", unit="L")
    public Attribute.Double potE;

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double netRad = this.netRad.getValue();
        double temperature = this.tmean.getValue();
        double rhum = this.rhum.getValue();
        double wind = this.wind.getValue();
        double elevation = this.elevation.getValue();
        double area = this.area.getValue();
        double abs_temp = ClimatologicalVariables.calc_absTemp(temperature, "degC");
        double delta_s = ClimatologicalVariables.calc_slopeOfSaturationPressureCurve(temperature);
        double pz = ClimatologicalVariables.calc_atmosphericPressure(elevation, abs_temp);
        double est = ClimatologicalVariables.calc_saturationVapourPressure(temperature);
        double ea = ClimatologicalVariables.calc_vapourPressure(rhum, est);
        double latH = ClimatologicalVariables.calc_latentHeatOfVaporization(temperature);
        double psy = ClimatologicalVariables.calc_psyConst(pz, latH);
        double groundHF = this.calc_groundHeatFlux(netRad);
        double vT = ClimatologicalVariables.calc_VirtualTemperature(abs_temp, pz, ea);
        double pa = ClimatologicalVariables.calc_AirDensityAtConstantPressure(vT, pz);
        double pE = 0.0;
        double letP = this.calcPenman(delta_s, netRad, groundHF, pa, 0.001031, est, ea, psy, wind);
        pE = letP / latH;
        pE *= area;
        if (this.time != null && this.tempRes.getValue().equals("m")) {
            int daysInMonth = this.time.getActualMaximum(5);
            pE *= (double)daysInMonth;
        }
        if (pE < 0.0) {
            pE = 0.0;
        }
        this.potE.setValue(pE);
    }

    private double calcPenman(double ds, double netRad, double groundHF, double pa, double CP, double est, double ea, double psy, double wind) {
        double fu = 0.27 + 0.2333 * wind;
        double Letp = (ds * (netRad - groundHF) + pa * CP * (est - ea) * fu) / (ds + psy);
        return Letp;
    }

    private double calc_groundHeatFlux(double netRad) {
        double g = 0.1 * netRad;
        return g;
    }
}

