/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.potET;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;

@JAMSComponentDescription(title="CalcDailyETP_PenmanMonteith", author="Peter Krause", description="Calculates potential ETP according Penman-Monteith")
public class Penman
extends JAMSComponent {
    public final double CP = 0.001031;
    public final double RSS = 150.0;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable wind")
    public Attribute.Double wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable net radiation")
    public Attribute.Double netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="potential ET [mm/ timeUnit]")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actual ET [mm/ timeUnit]")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="et calibration parameter")
    public Attribute.Double et_cal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Caching configuration: 0 - write cache, 1 - use cache, 2 - caching off", defaultValue="0")
    public Attribute.Integer dataCaching;
    private File cacheFile;
    private transient ObjectOutputStream writer;
    private transient ObjectInputStream reader;

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
        this.cacheFile = new File(this.getModel().getWorkspace().getTempDirectory(), this.getInstanceName() + ".cache");
        if (!this.cacheFile.exists() && this.dataCaching.getValue() == 1) {
            this.getModel().getRuntime().sendHalt(this.getInstanceName() + ": dataCaching is true but no cache file available!");
        }
        if (this.dataCaching.getValue() == 1) {
            this.reader = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
        } else if (this.dataCaching.getValue() == 0) {
            this.writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));
        }
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        if (this.dataCaching.getValue() == 1) {
            this.potET.setValue(this.reader.readDouble());
            this.actET.setValue(0.0);
        } else {
            double netRad = this.netRad.getValue();
            double temperature = this.tmean.getValue();
            double rhum = this.rhum.getValue();
            double wind = this.wind.getValue();
            double elevation = this.elevation.getValue();
            double area = this.area.getValue();
            double abs_temp = ClimatologicalVariables.calc_absTemp(temperature, "degC");
            double delta_s = ClimatologicalVariables.calc_slopeOfSaturationPressureCurve(temperature);
            double pz = ClimatologicalVariables.calc_atmosphericPressure(elevation, abs_temp);
            double est = ClimatologicalVariables.calc_saturationVapourPressure(temperature);
            double ea = ClimatologicalVariables.calc_vapourPressure(rhum, est);
            double latH = ClimatologicalVariables.calc_latentHeatOfVaporization(temperature);
            double psy = ClimatologicalVariables.calc_psyConst(pz, latH);
            double G = this.calc_groundHeatFlux(netRad);
            double vT = ClimatologicalVariables.calc_VirtualTemperature(abs_temp, pz, ea);
            double pa = ClimatologicalVariables.calc_AirDensityAtConstantPressure(vT, pz);
            double tempFactor = 0.0;
            double pET = 0.0;
            double aET = 0.0;
            if (this.tempRes.getValue().equals("d")) {
                tempFactor = 86400.0;
            } else if (this.tempRes.getValue().equals("h")) {
                tempFactor = 3600.0;
            } else if (this.tempRes.getValue().equals("m")) {
                tempFactor = 86400.0;
            }
            double Letp = 0.0;
            Letp = this.calcPM(delta_s, netRad, G, pa, 0.001031, est, ea, psy, tempFactor, wind);
            pET = Letp / latH;
            aET = 0.0;
            pET *= area;
            if (this.time != null && this.tempRes.getValue().equals("m")) {
                int daysInMonth = this.time.getActualMaximum(5);
                pET *= (double)daysInMonth;
            }
            if (pET < 0.0) {
                pET = 0.0;
            }
            this.potET.setValue(pET * this.et_cal.getValue());
            this.actET.setValue(aET);
            if (this.dataCaching.getValue() == 0) {
                this.writer.writeDouble(pET * this.et_cal.getValue());
            }
        }
    }

    public void cleanup() throws IOException {
        if (this.dataCaching.getValue() == 0) {
            this.writer.flush();
            this.writer.close();
        } else if (this.dataCaching.getValue() == 1) {
            this.reader.close();
        }
    }

    private double calcPM(double ds, double netRad, double G, double pa, double CP, double est, double ea, double psy, double tempFactor, double wind) {
        double fu = 0.27 + 0.2333 * wind;
        double Letp = (ds * (netRad - G) + pa * CP * (est - ea) * fu) / (ds + psy);
        return Letp;
    }

    private double calc_groundHeatFlux(double netRad) {
        double g = 0.1 * netRad;
        return g;
    }
}

