/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.physicalCalculations;

import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

public class DailySolarRadiationCalculationMethods {
    public static double calc_SunsetHourAngle(double latitude, double declination) {
        double sha = Math.acos(-1.0 * Math.tan(latitude) * Math.tan(declination));
        return sha;
    }

    public static double calc_maximumSunshineHours(double sunsetHourAngle) {
        double psh = 7.639437268410976 * sunsetHourAngle;
        return psh;
    }

    public static double calc_DailyExtraterrestrialRadiation(double Gsc, double dr, double ws, double lat, double decl) {
        double Ra = 458.3662361046586 * Gsc * dr * (ws * Math.sin(lat) * Math.sin(decl) + Math.cos(lat) * Math.cos(decl) * Math.sin(ws));
        return Ra;
    }

    public static double calc_DailyNetLongwaveRadiation(double tmean, double ea, double Rs, double Rs0, boolean debug) {
        double tabs = tmean + 273.16;
        double BOLTZMANN = 4.903E-9;
        double Rnl = 4.903E-9 * Math.pow(tabs, 4.0) * (0.34 - 0.14 * Math.sqrt(ea)) * (1.35 * (Rs / Rs0) - 0.35);
        return Rnl;
    }

    public static double calc_SoilHeatFlux(double Rn, double N) {
        double Gd = 0.1 * Rn * N / 24.0;
        double Gn = 0.5 * Rn * ((24.0 - N) / 24.0);
        double G = Gd + Gn;
        return G;
    }

    public static double calcDayFraction(double lat, int julDay) {
        double declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
        double latRad = MathematicalCalculations.deg2rad(lat);
        double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
        double maximumSunshine = DailySolarRadiationCalculationMethods.calc_maximumSunshineHours(sunsetHourAngle);
        double dayFraction = maximumSunshine / 24.0;
        if (dayFraction > 1.0) {
            System.out.println("Problem in DailySolarRadiationCalculationMethods: Day fraction is larger than 24");
            dayFraction = 1.0;
        }
        if (dayFraction < 0.0) {
            System.out.println("Problem in DailySolarRadiationCalculationMethods: Day fraction is smaller than 24");
            dayFraction = 0.0;
        }
        return dayFraction;
    }
}

