/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;

@JAMSComponentDescription(title="StandardLUReader", author="Sven Kralisch", description="This component reads an ASCII file containing land use information and adds them to model entities.", date="2005-11-10", version="1.1_0")
public class StandardLUReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Land use parameter file name")
    public Attribute.String luFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hru objects")
    public Attribute.EntityCollection hrus;

    public void init() {
        Attribute.EntityCollection lus = this.getModel().getRuntime().getDataFactory().createEntityCollection();
        lus.setEntities(J2KFunctions.readParas(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.luFileName.getValue()), this.getModel()));
        HashMap<Double, Attribute.Entity> luMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity lu : lus.getEntities()) {
            luMap.put(lu.getDouble("LID"), lu);
        }
        for (Attribute.Entity e : this.hrus.getEntities()) {
            Attribute.Entity lu;
            lu = (Attribute.Entity)luMap.get(e.getDouble("landuseID"));
            e.setObject("landuse", (Object)lu);
            if (lu == null) {
                this.getModel().getRuntime().sendHalt("Error landuse id " + e.getDouble("landuseID") + " of entity " + e.getId() + " not found!");
                return;
            }
            Object[] attrs = lu.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                Object o = lu.getObject((String)attrs[i]);
                if (o instanceof Attribute.String) continue;
                e.setObject((String)attrs[i], o);
            }
        }
        this.getModel().getRuntime().println("Landuse parameter file processed ...", 2);
    }
}

