/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.geographicalCalculations;

import java.awt.EventQueue;
import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;

public class UTMConversion {
    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                double[] xy = new double[2];
                double[] latLong = new double[]{-31.4459, -64.5148};
                xy = UTMConversion.latLong2UTM(latLong[0], latLong[1]);
                System.out.println("X: " + xy[0] + " Y: " + xy[1]);
                String zoneStr = UTMConversion.getZoneStr(latLong[0], latLong[1]);
                System.out.println("ZoneStr: " + zoneStr);
                int zone = UTMConversion.getZoneNumber(latLong[0], latLong[1]);
                latLong = UTMConversion.utm2LatLong(xy[0], xy[1], zoneStr);
                System.out.println("Lat: " + latLong[0] + " Long: " + latLong[1]);
            }
        });
    }

    public static int getZoneNumber(double lat, double lon) {
        String zone = UTMConversion.getZoneStr(lat, lon);
        int len = zone.length();
        int zsIdx = len - 1;
        char zoneChr = zone.charAt(len - 1);
        String zoneStr = "" + zoneChr;
        String numberPart = zone.substring(0, zsIdx);
        int zoneNumber = Integer.parseInt(numberPart);
        return zoneNumber;
    }

    public static int getZoneNumber(String zoneStr) {
        int len = zoneStr.length();
        int zsIdx = len - 1;
        int nmIdx = zsIdx - 1;
        char zoneChr = zoneStr.charAt(len - 1);
        String numberPart = zoneStr.substring(0, zsIdx);
        int zoneNumber = Integer.parseInt(numberPart);
        return zoneNumber;
    }

    public static boolean isSouth(String zone) {
        boolean isSouth = false;
        String[] southLetters = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M"};
        int len = zone.length();
        int zsIdx = len - 1;
        int nmIdx = zsIdx - 1;
        char zoneChr = zone.charAt(len - 1);
        String zoneStr = "" + zoneChr;
        for (int i = 0; i < southLetters.length; ++i) {
            if (!zoneStr.equals(southLetters[i])) continue;
            isSouth = true;
        }
        return isSouth;
    }

    public static String getZoneStr(double lat, double lon) {
        String LetterDesignator = 84.0 >= lat && lat >= 72.0 ? "X" : (72.0 > lat && lat >= 64.0 ? "W" : (64.0 > lat && lat >= 56.0 ? "V" : (56.0 > lat && lat >= 48.0 ? "U" : (48.0 > lat && lat >= 40.0 ? "T" : (40.0 > lat && lat >= 32.0 ? "S" : (32.0 > lat && lat >= 24.0 ? "R" : (24.0 > lat && lat >= 16.0 ? "Q" : (16.0 > lat && lat >= 8.0 ? "P" : (8.0 > lat && lat >= 0.0 ? "N" : (0.0 > lat && lat >= -8.0 ? "M" : (-8.0 > lat && lat >= -16.0 ? "L" : (-16.0 > lat && lat >= -24.0 ? "K" : (-24.0 > lat && lat >= -32.0 ? "J" : (-32.0 > lat && lat >= -40.0 ? "H" : (-40.0 > lat && lat >= -48.0 ? "G" : (-48.0 > lat && lat >= -56.0 ? "F" : (-56.0 > lat && lat >= -64.0 ? "E" : (-64.0 > lat && lat >= -72.0 ? "D" : (-72.0 > lat && lat >= -80.0 ? "C" : "Z")))))))))))))))))));
        double longTemp = lon + 180.0 - (double)((int)((lon + 180.0) / 360.0) * 360) - 180.0;
        int zoneNumber = (int)((longTemp + 180.0) / 6.0) + 1;
        if (lat >= 56.0 && lat < 64.0 && longTemp >= 3.0 && longTemp < 12.0) {
            zoneNumber = 32;
        }
        String zone = "" + zoneNumber + LetterDesignator;
        return zone;
    }

    public static double[] latLong2UTM(double lat, double lon) {
        double[] utmXY = new double[2];
        double eqRad = 6378137.0;
        double eccSquared = 0.00669438;
        double k0 = 0.9996;
        double latRad = MathematicalCalculations.deg2rad(lat);
        double longRad = MathematicalCalculations.deg2rad(lon);
        int zoneNumber = UTMConversion.getZoneNumber(lat, lon);
        double longOrigin = (zoneNumber - 1) * 6 - 180 + 3;
        double longOriginRad = MathematicalCalculations.deg2rad(longOrigin);
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double n = eqRad / Math.sqrt(1.0 - eccSquared * Math.sin(latRad) * Math.sin(latRad));
        double t = Math.tan(latRad) * Math.tan(latRad);
        double c = eccPrimeSquared * Math.cos(latRad) * Math.cos(latRad);
        double a = Math.cos(latRad) * (longRad - longOriginRad);
        double m = eqRad * ((1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0) * latRad - (3.0 * eccSquared / 8.0 + 3.0 * eccSquared * eccSquared / 32.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(2.0 * latRad) + (15.0 * eccSquared * eccSquared / 256.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(4.0 * latRad) - 35.0 * eccSquared * eccSquared * eccSquared / 3072.0 * Math.sin(6.0 * latRad));
        utmXY[0] = k0 * n * (a + (1.0 - t + c) * a * a * a / 6.0 + (5.0 - 18.0 * t + t * t + 72.0 * c - 58.0 * eccPrimeSquared) * a * a * a * a * a / 120.0) + 500000.0;
        utmXY[1] = k0 * (m + n * Math.tan(latRad) * (a * a / 2.0 + (5.0 - t + 9.0 * c + 4.0 * c * c) * a * a * a * a / 24.0 + (61.0 - 58.0 * t + t * t + 600.0 * c - 330.0 * eccPrimeSquared) * a * a * a * a * a * a / 720.0));
        if (lat < 0.0) {
            utmXY[1] = utmXY[1] + 1.0E7;
        }
        return utmXY;
    }

    public static double[] utm2LatLong(double utmX, double utmY, String zoneStr) {
        double[] latLong = new double[2];
        double eqRad = 6378137.0;
        double eccSquared = 0.00669438;
        double k0 = 0.9996;
        double e1 = (1.0 - Math.sqrt(1.0 - eccSquared)) / (1.0 + Math.sqrt(1.0 - eccSquared));
        utmX -= 500000.0;
        if (UTMConversion.isSouth(zoneStr)) {
            utmY -= 1.0E7;
        }
        int zone = UTMConversion.getZoneNumber(zoneStr);
        double longOrigin = (zone - 1) * 6 - 180 + 3;
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double m = utmY / k0;
        double mu = m / (eqRad * (1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0));
        double phi1Rad = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
        double n1 = eqRad / Math.sqrt(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
        double t1 = Math.tan(phi1Rad) * Math.tan(phi1Rad);
        double c1 = eccPrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
        double r1 = eqRad * (1.0 - eccSquared) / Math.pow(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
        double d = utmX / (n1 * k0);
        double latRad = phi1Rad - n1 * Math.tan(phi1Rad) / r1 * (d * d / 2.0 - (5.0 + 3.0 * t1 + 10.0 * c1 - 4.0 * c1 * c1 - 9.0 * eccPrimeSquared) * d * d * d * d / 24.0 + (61.0 + 90.0 * t1 + 298.0 * c1 + 45.0 * t1 * t1 - 252.0 * eccPrimeSquared - 3.0 * c1 * c1) * d * d * d * d * d * d / 720.0);
        latLong[0] = MathematicalCalculations.rad2deg(latRad);
        double longRad = (d - (1.0 + 2.0 * t1 + c1) * d * d * d / 6.0 + (5.0 - 2.0 * c1 + 28.0 * t1 - 3.0 * c1 * c1 + 8.0 * eccPrimeSquared + 24.0 * t1 * t1) * d * d * d * d * d / 120.0) / Math.cos(phi1Rad);
        latLong[1] = MathematicalCalculations.rad2deg(longRad) + longOrigin;
        return latLong;
    }
}

