/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.model.Model;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class J2KFunctions {
    private static String[] breakArrayString(String value) {
        if (value.startsWith("[") && value.endsWith("]")) {
            value = value.substring(1, value.length() - 1);
            return value.split(",");
        }
        return null;
    }

    private static void setTypedValue(Attribute.Entity e, String name, String value, Class type) {
        if (type.equals(Attribute.Long.class)) {
            e.setLong(name, Long.parseLong(value));
        } else if (type.equals(Attribute.LongArray.class)) {
            String[] values = J2KFunctions.breakArrayString(value);
            if (values == null) {
                Logger.getLogger(J2KFunctions.class.getName()).log(Level.SEVERE, "Not an array: " + value);
            }
            long[] doubles = new long[values.length];
            int j = 0;
            for (String subString : values) {
                doubles[j++] = Long.parseLong(subString);
            }
            Attribute.LongArray array = DefaultDataFactory.getDataFactory().createLongArray();
            array.setValue(doubles);
            e.setObject(name, (Object)array);
        } else if (type.equals(Attribute.Boolean.class)) {
            e.setObject(name, (Object)Boolean.parseBoolean(value));
        } else if (type.equals(Attribute.BooleanArray.class)) {
            Attribute.BooleanArray values = J2KFunctions.breakArrayString(value);
            if (values == null) {
                Logger.getLogger(J2KFunctions.class.getName()).log(Level.SEVERE, "Not an array: " + value);
            }
            boolean[] doubles = new boolean[((String[])values).length];
            int j = 0;
            for (String subString : values) {
                doubles[j++] = Boolean.parseBoolean(subString);
            }
            Attribute.BooleanArray array = DefaultDataFactory.getDataFactory().createBooleanArray();
            array.setValue(doubles);
            e.setObject(name, (Object)array);
        } else if (type.equals(Attribute.Double.class)) {
            e.setDouble(name, Double.parseDouble(value));
        } else if (type.equals(Attribute.DoubleArray.class)) {
            Attribute.DoubleArray values = J2KFunctions.breakArrayString(value);
            if (values == null) {
                Logger.getLogger(J2KFunctions.class.getName()).log(Level.SEVERE, "Not an array: " + value);
            }
            double[] doubles = new double[((String[])values).length];
            int j = 0;
            for (String subString : values) {
                doubles[j++] = Double.parseDouble(subString);
            }
            Attribute.DoubleArray array = DefaultDataFactory.getDataFactory().createDoubleArray();
            array.setValue(doubles);
            e.setObject(name, (Object)array);
        } else if (type.equals(Attribute.Integer.class)) {
            e.setInt(name, Integer.parseInt(value));
        } else if (type.equals(Attribute.IntegerArray.class)) {
            Attribute.IntegerArray values = J2KFunctions.breakArrayString(value);
            if (values == null) {
                Logger.getLogger(J2KFunctions.class.getName()).log(Level.SEVERE, "Not an array: " + value);
            }
            int[] doubles = new int[((String[])values).length];
            int j = 0;
            for (String subString : values) {
                doubles[j++] = Integer.parseInt(subString);
            }
            Attribute.IntegerArray array = DefaultDataFactory.getDataFactory().createIntegerArray();
            array.setValue(doubles);
            e.setObject(name, (Object)array);
        } else if (type.equals(Attribute.Float.class)) {
            e.setFloat(name, Float.parseFloat(value));
        } else if (type.equals(Attribute.FloatArray.class)) {
            Attribute.FloatArray values = J2KFunctions.breakArrayString(value);
            if (values == null) {
                Logger.getLogger(J2KFunctions.class.getName()).log(Level.SEVERE, "Not an array: " + value);
            }
            float[] doubles = new float[((String[])values).length];
            int j = 0;
            for (String subString : values) {
                doubles[j++] = Float.parseFloat(subString);
            }
            Attribute.FloatArray array = DefaultDataFactory.getDataFactory().createFloatArray();
            array.setValue(doubles);
            e.setObject(name, (Object)array);
        } else if (type.equals(Attribute.Calendar.class)) {
            Attribute.Calendar calendar = DefaultDataFactory.getDataFactory().createCalendar();
            calendar.setValue(value);
            e.setObject(name, (Object)calendar);
        } else if (type.equals(Attribute.TimeInterval.class)) {
            Attribute.TimeInterval interval = DefaultDataFactory.getDataFactory().createTimeInterval();
            interval.setValue(value);
            e.setObject(name, (Object)interval);
        } else if (type.equals(Attribute.StringArray.class)) {
            Attribute.StringArray values = J2KFunctions.breakArrayString(value);
            if (values == null) {
                Logger.getLogger(J2KFunctions.class.getName()).log(Level.SEVERE, "Not an array: " + value);
            }
            String[] doubles = new String[((String[])values).length];
            int j = 0;
            for (String subString : values) {
                doubles[j++] = subString;
            }
            Attribute.StringArray array = DefaultDataFactory.getDataFactory().createStringArray();
            array.setValue(doubles);
            e.setObject(name, (Object)array);
        } else if (type.equals(Attribute.String.class)) {
            e.setObject(name, (Object)value);
        }
    }

    public static ArrayList<Attribute.Entity> readParas(String fileName, Model model) {
        ArrayList<Attribute.Entity> entityList = new ArrayList<Attribute.Entity>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            boolean typedFile = false;
            while (s.startsWith("#")) {
                s = reader.readLine();
                if (!s.equalsIgnoreCase("#TYPED")) continue;
                typedFile = true;
            }
            Vector<String> attributeNames = new Vector<String>();
            Vector<Class> attributeTypes = new Vector<Class>();
            StringTokenizer tokenizer = new StringTokenizer(s, "\t");
            while (tokenizer.hasMoreTokens()) {
                String aName = tokenizer.nextToken();
                if (aName.equals("to-reach")) {
                    aName = "to_reach";
                }
                attributeNames.add(aName);
            }
            if (typedFile) {
                s = reader.readLine();
                tokenizer = new StringTokenizer(s, "\t");
                while (tokenizer.hasMoreTokens()) {
                    String aType = tokenizer.nextToken();
                    if (aType.compareTo("Long") == 0) {
                        attributeTypes.add(Attribute.Long.class);
                        continue;
                    }
                    if (aType.compareTo("LongArray") == 0) {
                        attributeTypes.add(Attribute.LongArray.class);
                        continue;
                    }
                    if (aType.compareTo("Boolean") == 0) {
                        attributeTypes.add(Attribute.Boolean.class);
                        continue;
                    }
                    if (aType.compareTo("BooleanArray") == 0) {
                        attributeTypes.add(Attribute.BooleanArray.class);
                        continue;
                    }
                    if (aType.compareTo("Double") == 0) {
                        attributeTypes.add(Attribute.Double.class);
                        continue;
                    }
                    if (aType.compareTo("DoubleArray") == 0) {
                        attributeTypes.add(Attribute.DoubleArray.class);
                        continue;
                    }
                    if (aType.compareTo("Integer") == 0) {
                        attributeTypes.add(Attribute.Integer.class);
                        continue;
                    }
                    if (aType.compareTo("IntegerArray") == 0) {
                        attributeTypes.add(Attribute.IntegerArray.class);
                        continue;
                    }
                    if (aType.compareTo("Float") == 0) {
                        attributeTypes.add(Attribute.Float.class);
                        continue;
                    }
                    if (aType.compareTo("FloatArray") == 0) {
                        attributeTypes.add(Attribute.FloatArray.class);
                        continue;
                    }
                    if (aType.compareTo("Calendar") == 0) {
                        attributeTypes.add(Attribute.Calendar.class);
                        continue;
                    }
                    if (aType.compareTo("TimeInterval") == 0) {
                        attributeTypes.add(Attribute.TimeInterval.class);
                        continue;
                    }
                    if (aType.compareTo("StringArray") == 0) {
                        attributeTypes.add(Attribute.StringArray.class);
                        continue;
                    }
                    if (aType.compareTo("String") == 0) {
                        attributeTypes.add(Attribute.String.class);
                        continue;
                    }
                    Logger.getLogger(J2KFunctions.class.getName()).log(Level.SEVERE, "Unknown type: " + aType);
                }
            }
            reader.readLine();
            reader.readLine();
            reader.readLine();
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                Attribute.Entity e = DefaultDataFactory.getDataFactory().createEntity();
                String[] string = s.split("\t");
                for (int i = 0; i < attributeNames.size(); ++i) {
                    if (typedFile) {
                        J2KFunctions.setTypedValue(e, (String)attributeNames.get(i), string[i], (Class)attributeTypes.get(i));
                        continue;
                    }
                    try {
                        e.setDouble((String)attributeNames.get(i), Double.parseDouble(string[i]));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        if (string[i].startsWith("[") && string[i].endsWith("]")) {
                            string[i] = string[i].substring(1, string[i].length() - 1);
                            int j = 0;
                            String[] subStrings = string[i].split(",");
                            Attribute.DoubleArray array = DefaultDataFactory.getDataFactory().createDoubleArray();
                            double[] doubles = new double[subStrings.length];
                            for (String subString : subStrings) {
                                doubles[j++] = Double.parseDouble(subString);
                            }
                            array.setValue(doubles);
                            e.setObject((String)attributeNames.get(i), (Object)array);
                            continue;
                        }
                        Attribute.String stringValue = DefaultDataFactory.getDataFactory().createString();
                        stringValue.setValue(string[i]);
                        e.setObject((String)attributeNames.get(i), (Object)stringValue);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        model.getRuntime().sendErrorMsg("Too few columns in row \"" + s + "\"!");
                    }
                }
                entityList.add(e);
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            model.getRuntime().handle((Throwable)ioe);
        }
        return entityList;
    }

    public static ArrayList<Attribute.Entity> createStationEntities(String fileName, Model model) {
        ArrayList<Attribute.Entity> entityList = new ArrayList<Attribute.Entity>();
        int headerLineCount = 0;
        String dataName = null;
        String tres = null;
        String start = null;
        String end = null;
        double[] statx = null;
        double[] staty = null;
        double[] statelev = null;
        String line = "#";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while (line.charAt(0) == '#') {
                line = reader.readLine();
                ++headerLineCount;
            }
            StringTokenizer strTok = new StringTokenizer(line, "\t");
            String token = strTok.nextToken();
            while (token.compareTo("@dataVal") != 0) {
                String desc;
                int i;
                if (token.compareTo("@dataValueAttribs") == 0) {
                    line = reader.readLine();
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, "\t");
                    dataName = strTok.nextToken();
                    double lowBound = Double.parseDouble(strTok.nextToken());
                    double uppBound = Double.parseDouble(strTok.nextToken());
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, "\t");
                    token = strTok.nextToken();
                    ++headerLineCount;
                    continue;
                }
                if (token.compareTo("@dataSetAttribs") == 0) {
                    line = reader.readLine();
                    for (i = 0; i < 4; ++i) {
                        ++headerLineCount;
                        strTok = new StringTokenizer(line, "\t");
                        desc = strTok.nextToken();
                        if (desc.compareTo("missingDataVal") == 0) {
                            double missData = Double.parseDouble(strTok.nextToken());
                        } else if (desc.compareTo("dataStart") == 0) {
                            start = strTok.nextToken();
                        } else if (desc.compareTo("dataEnd") == 0) {
                            end = strTok.nextToken();
                        } else if (desc.compareTo("tres") == 0) {
                            tres = strTok.nextToken();
                        }
                        line = reader.readLine();
                        strTok = new StringTokenizer(line, "\t");
                        token = strTok.nextToken();
                    }
                    continue;
                }
                if (token.compareTo("@statAttribVal") != 0) continue;
                line = reader.readLine();
                for (i = 0; i < 6; ++i) {
                    int j;
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, "\t");
                    desc = strTok.nextToken();
                    int nstat = strTok.countTokens();
                    if (desc.compareTo("name") == 0) {
                        String[] name = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            name[j] = strTok.nextToken();
                        }
                    } else if (desc.compareTo("ID") == 0) {
                        String[] id = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            id[j] = strTok.nextToken();
                        }
                    } else if (desc.compareTo("elevation") == 0) {
                        statelev = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statelev[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("x") == 0) {
                        statx = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statx[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("y") == 0) {
                        staty = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            staty[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("dataColumn") == 0) {
                        ++headerLineCount;
                        ++headerLineCount;
                    }
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, "\t");
                    token = strTok.nextToken();
                }
            }
        }
        catch (IOException ioe) {
            model.getRuntime().handle((Throwable)ioe);
        }
        return entityList;
    }
}

