/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KArrayGrabber", author="Peter Krause", description="This component selects data values from arrays representinga standard year.", version="1.0_0", date="2011-05-30")
public class J2KArrayGrabber
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [m | d | h]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="extraTerrRadiationArray")
    public Attribute.DoubleArray extRadArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="LeafAreaIndexArray")
    public Attribute.DoubleArray LAIArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="EffectiveHeightArray")
    public Attribute.DoubleArray effHArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="rsc0 Array")
    public Attribute.DoubleArray rsc0Array;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="slopeAscpectCorrectionFactorArray")
    public Attribute.DoubleArray slAsCfArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actExtraTerrRadiation")
    public Attribute.Double actExtRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actLAI")
    public Attribute.Double actLAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actEffH")
    public Attribute.Double actEffH;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actRsc0")
    public Attribute.Double actRsc0;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Haude factor array")
    public Attribute.DoubleArray haudeFactorArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actHaudeFactor", defaultValue="0")
    public Attribute.Double actHaudeFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actSlopeAscpectCorrectionFactor")
    public Attribute.Double actSlAsCf;

    public void init() throws Attribute.Entity.NoSuchAttributeException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        int monthCount = this.time.get(2);
        int dayCount = this.time.get(6) - 1;
        int hourCount = this.time.get(11) + 24 * dayCount;
        double in_LAI = JAMS.getMissingDataValue();
        double in_effH = JAMS.getMissingDataValue();
        double in_extRad = JAMS.getMissingDataValue();
        double in_scf = JAMS.getMissingDataValue();
        double in_rsc0 = JAMS.getMissingDataValue();
        double in_haudeF = JAMS.getMissingDataValue();
        if (this.rsc0Array != null) {
            in_rsc0 = this.rsc0Array.getValue()[monthCount];
        }
        if (this.haudeFactorArray != null) {
            in_haudeF = this.haudeFactorArray.getValue()[monthCount];
        }
        if (this.tempRes.getValue().equals("m")) {
            if (this.LAIArray != null) {
                in_LAI = this.LAIArray.getValue()[monthCount];
            }
            if (this.effHArray != null) {
                in_effH = this.effHArray.getValue()[monthCount];
            }
            if (this.extRadArray != null) {
                in_extRad = this.extRadArray.getValue()[monthCount];
            }
            if (this.slAsCfArray != null) {
                in_scf = this.slAsCfArray.getValue()[monthCount];
            }
        } else if (this.tempRes.getValue().equals("d")) {
            if (this.LAIArray != null) {
                in_LAI = this.LAIArray.getValue()[dayCount];
            }
            if (this.effHArray != null) {
                in_effH = this.effHArray.getValue()[dayCount];
            }
            if (this.extRadArray != null) {
                in_extRad = this.extRadArray.getValue()[dayCount];
            }
            if (this.slAsCfArray != null) {
                in_scf = this.slAsCfArray.getValue()[dayCount];
            }
        } else if (this.tempRes.getValue().equals("h")) {
            if (this.LAIArray != null) {
                in_LAI = this.LAIArray.getValue()[dayCount];
            }
            if (this.effHArray != null) {
                in_effH = this.effHArray.getValue()[dayCount];
            }
            if (this.extRadArray != null) {
                in_extRad = this.extRadArray.getValue()[hourCount];
            }
            if (this.slAsCfArray != null) {
                in_scf = this.slAsCfArray.getValue()[dayCount];
            }
        }
        this.actLAI.setValue(in_LAI);
        this.actEffH.setValue(in_effH);
        this.actRsc0.setValue(in_rsc0);
        this.actSlAsCf.setValue(in_scf);
        this.actExtRad.setValue(in_extRad);
        this.actHaudeFactor.setValue(in_haudeF);
    }

    public void cleanup() {
    }
}

