/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Thorntwaite snowmelt (McCabe & Markstrom 2007)", author="Sven Kralisch & Manfred Fink", date="17. 12 2024", description="This component calculates the snow melt based on a snow storage, potET, according to McCabe & Markstrom 2007 temperature and precipitation")
public class Snow_thorn
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Amount of water currently stored as snow")
    public Attribute.Double snowStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current temperature")
    public Attribute.Double temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Current precipitation")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Simulated snow melt water")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calibration parameter rain temperature")
    public Attribute.Double rainTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calibration parameter snow temperature")
    public Attribute.Double snowTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calibration parameter maximum melt proportion per timestep", defaultValue="0.5")
    public Attribute.Double meltmax;

    public void run() {
        double snowStorage = this.snowStorage.getValue();
        double temp = this.temp.getValue();
        double snowTemp = this.snowTemp.getValue();
        double rainTemp = this.rainTemp.getValue();
        double meltmax = this.meltmax.getValue();
        double precip = this.precip.getValue();
        double snowMelt = 0.0;
        double P_snow = Math.max(Math.min(precip * (rainTemp - temp) / (rainTemp - snowTemp), precip), 0.0);
        precip -= P_snow;
        snowStorage += P_snow;
        double SMF = Math.max(Math.min((temp - snowTemp) / (rainTemp - snowTemp) * meltmax, meltmax), 0.0);
        if ((snowStorage -= (snowMelt = SMF * snowStorage)) < 1.0 && temp > rainTemp + 1.0) {
            snowMelt += snowStorage;
            snowStorage = 0.0;
        }
        this.snowStorage.setValue(snowStorage);
        this.snowMelt.setValue(snowMelt);
        this.precip.setValue(precip);
    }
}

