/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Thorntwaite snowmelt", author="Sven Kralisch", date="30. September 2005", description="This component calculates the snow melt based on a snow storage, potET, temperature and precipitation")
public class Snow
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Amount of water currently stored as snow")
    public Attribute.Double snowStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current potential ET")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current temperature")
    public Attribute.Double temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current precipitation")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Simulated snow melt water")
    public Attribute.Double snowMelt;

    public void run() {
        double snowStorage = this.snowStorage.getValue();
        double temp = this.temp.getValue();
        double potET = this.potET.getValue();
        double precip = this.precip.getValue();
        double pmpe = precip - potET;
        double snowMelt = 0.0;
        if (temp < 0.0 && pmpe > 0.0) {
            snowStorage = precip + snowStorage;
        }
        if (snowStorage > 0.0 && temp >= 0.0) {
            snowMelt = snowStorage * 0.5;
            snowStorage *= 0.5;
        } else if (snowStorage == 0.0) {
            snowMelt = 0.0;
        }
        this.snowStorage.setValue(snowStorage);
        this.snowMelt.setValue(snowMelt);
    }
}

