/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.io.GenericDataReader;
import jams.io.JAMSTableDataArray;
import jams.io.JAMSTableDataConverter;
import jams.io.JAMSTableDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.util.ArrayList;

public class EntityProvider
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE)
    public Attribute.EntityCollection entities;
    private JAMSTableDataStore store;

    public void init() {
        ArrayList<Attribute.Entity> entityList = new ArrayList<Attribute.Entity>();
        this.store = new GenericDataReader(this.fileName.getValue(), false, 4, 6);
        while (this.store.hasNext()) {
            Attribute.Entity e = this.getModel().getRuntime().getDataFactory().createEntity();
            JAMSTableDataArray da = this.store.getNext();
            double[] vals = JAMSTableDataConverter.toDouble((JAMSTableDataArray)da);
            Attribute.Double d = this.getModel().getRuntime().getDataFactory().createDouble();
            d.setValue(vals[0]);
            e.setObject("latitude", (Object)d);
            d = this.getModel().getRuntime().getDataFactory().createDouble();
            d.setValue(vals[1]);
            e.setObject("soilMoistStorCap", (Object)d);
            d = this.getModel().getRuntime().getDataFactory().createDouble();
            d.setValue(vals[2]);
            e.setObject("snowStorage", (Object)d);
            d = this.getModel().getRuntime().getDataFactory().createDouble();
            d.setValue(vals[3]);
            e.setObject("runoffFactor", (Object)d);
            d = this.getModel().getRuntime().getDataFactory().createDouble();
            d.setValue(vals[4]);
            e.setObject("prestor", (Object)d);
            d = this.getModel().getRuntime().getDataFactory().createDouble();
            d.setValue(vals[5]);
            e.setObject("remain", (Object)d);
            entityList.add(e);
        }
        this.entities.setEntities(entityList);
    }
}

