/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.quality;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.Result;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementImpl
extends MetadataEntity
implements Element {
    private static final long serialVersionUID = -3542504624077298894L;
    private Collection<InternationalString> namesOfMeasure;
    private Identifier measureIdentification;
    private InternationalString measureDescription;
    private EvaluationMethodType evaluationMethodType;
    private InternationalString evaluationMethodDescription;
    private Citation evaluationProcedure;
    private long date1 = Long.MIN_VALUE;
    private long date2 = Long.MIN_VALUE;
    private Collection<Result> results;

    public ElementImpl() {
    }

    public ElementImpl(Element source) {
        super(source);
    }

    public ElementImpl(Result result) {
        this.setResults(Collections.singleton(result));
    }

    public synchronized Collection<InternationalString> getNamesOfMeasure() {
        this.namesOfMeasure = this.nonNullCollection(this.namesOfMeasure, InternationalString.class);
        return this.namesOfMeasure;
    }

    public synchronized void setNamesOfMeasure(Collection<? extends InternationalString> newValues) {
        this.namesOfMeasure = this.copyCollection(newValues, this.namesOfMeasure, InternationalString.class);
    }

    @Override
    public Identifier getMeasureIdentification() {
        return this.measureIdentification;
    }

    public synchronized void setMeasureIdentification(Identifier newValue) {
        this.checkWritePermission();
        this.measureIdentification = newValue;
    }

    @Override
    public InternationalString getMeasureDescription() {
        return this.measureDescription;
    }

    public synchronized void setMeasureDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.measureDescription = newValue;
    }

    @Override
    public EvaluationMethodType getEvaluationMethodType() {
        return this.evaluationMethodType;
    }

    public synchronized void setEvaluationMethodType(EvaluationMethodType newValue) {
        this.checkWritePermission();
        this.evaluationMethodType = newValue;
    }

    @Override
    public InternationalString getEvaluationMethodDescription() {
        return this.evaluationMethodDescription;
    }

    public synchronized void setEvaluationMethodDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.evaluationMethodDescription = newValue;
    }

    @Override
    public Citation getEvaluationProcedure() {
        return this.evaluationProcedure;
    }

    public synchronized void setEvaluationProcedure(Citation newValue) {
        this.checkWritePermission();
        this.evaluationProcedure = newValue;
    }

    public synchronized Collection<Date> getDates() {
        if (this.date1 == Long.MIN_VALUE) {
            return Collections.emptyList();
        }
        if (this.date2 == Long.MIN_VALUE) {
            return Collections.singleton(new Date(this.date1));
        }
        return Arrays.asList(new Date(this.date1), new Date(this.date2));
    }

    public void setDates(Collection<Date> newValues) {
        this.checkWritePermission();
        this.date2 = Long.MIN_VALUE;
        this.date1 = Long.MIN_VALUE;
        Iterator<Date> it = newValues.iterator();
        if (it.hasNext()) {
            this.date1 = it.next().getTime();
            if (it.hasNext()) {
                this.date2 = it.next().getTime();
                if (it.hasNext()) {
                    throw new IllegalArgumentException(Errors.format(67));
                }
            }
        }
    }

    public synchronized Collection<Result> getResults() {
        this.results = this.nonNullCollection(this.results, Result.class);
        return this.results;
    }

    public synchronized void setResults(Collection<? extends Result> newValues) {
        this.results = this.copyCollection(newValues, this.results, Result.class);
    }
}

