/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.DecodingException;
import com.sun.xml.internal.org.jvnet.mimepull.LineInputStream;
import com.sun.xml.internal.org.jvnet.mimepull.PropUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class UUDecoderStream
extends FilterInputStream {
    private String name;
    private int mode;
    private byte[] buffer = new byte[45];
    private int bufsize = 0;
    private int index = 0;
    private boolean gotPrefix = false;
    private boolean gotEnd = false;
    private LineInputStream lin;
    private boolean ignoreErrors;
    private boolean ignoreMissingBeginEnd;
    private String readAhead;

    public UUDecoderStream(InputStream inputStream) {
        super(inputStream);
        this.lin = new LineInputStream(inputStream);
        this.ignoreErrors = PropUtil.getBooleanSystemProperty("mail.mime.uudecode.ignoreerrors", false);
        this.ignoreMissingBeginEnd = PropUtil.getBooleanSystemProperty("mail.mime.uudecode.ignoremissingbeginend", false);
    }

    public UUDecoderStream(InputStream inputStream, boolean bl, boolean bl2) {
        super(inputStream);
        this.lin = new LineInputStream(inputStream);
        this.ignoreErrors = bl;
        this.ignoreMissingBeginEnd = bl2;
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.readPrefix();
            if (!this.decode()) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = this.read();
            if (n4 == -1) {
                if (n3 != 0) break;
                n3 = -1;
                break;
            }
            byArray[n + n3] = (byte)n4;
        }
        return n3;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    public String getName() throws IOException {
        this.readPrefix();
        return this.name;
    }

    public int getMode() throws IOException {
        this.readPrefix();
        return this.mode;
    }

    private void readPrefix() throws IOException {
        block10: {
            String string;
            if (this.gotPrefix) {
                return;
            }
            this.mode = 438;
            this.name = "encoder.buf";
            while (true) {
                if ((string = this.lin.readLine()) == null) {
                    if (!this.ignoreMissingBeginEnd) {
                        throw new DecodingException("UUDecoder: Missing begin");
                    }
                    this.gotPrefix = true;
                    this.gotEnd = true;
                    break block10;
                }
                if (string.regionMatches(false, 0, "begin", 0, 5)) {
                    block11: {
                        try {
                            this.mode = Integer.parseInt(string.substring(6, 9));
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (this.ignoreErrors) break block11;
                            throw new DecodingException("UUDecoder: Error in mode: " + numberFormatException.toString());
                        }
                    }
                    if (string.length() > 10) {
                        this.name = string.substring(10);
                    } else if (!this.ignoreErrors) {
                        throw new DecodingException("UUDecoder: Missing name: " + string);
                    }
                    this.gotPrefix = true;
                    break block10;
                }
                if (!this.ignoreMissingBeginEnd || string.length() == 0) continue;
                int n = string.charAt(0);
                int n2 = ((n = n - 32 & 0x3F) * 8 + 5) / 6;
                if (n2 == 0 || string.length() >= n2 + 1) break;
            }
            this.readAhead = string;
            this.gotPrefix = true;
        }
    }

    private boolean decode() throws IOException {
        int n;
        String string;
        int n2;
        block12: {
            if (this.gotEnd) {
                return false;
            }
            this.bufsize = 0;
            n2 = 0;
            while (true) {
                if (this.readAhead != null) {
                    string = this.readAhead;
                    this.readAhead = null;
                } else {
                    string = this.lin.readLine();
                }
                if (string == null) {
                    if (!this.ignoreMissingBeginEnd) {
                        throw new DecodingException("UUDecoder: Missing end at EOF");
                    }
                    this.gotEnd = true;
                    return false;
                }
                if (string.equals("end")) {
                    this.gotEnd = true;
                    return false;
                }
                if (string.length() == 0) continue;
                n2 = string.charAt(0);
                if (n2 < 32) {
                    if (this.ignoreErrors) continue;
                    throw new DecodingException("UUDecoder: Buffer format error");
                }
                if ((n2 = n2 - 32 & 0x3F) == 0) {
                    string = this.lin.readLine();
                    if (!(string != null && string.equals("end") || this.ignoreMissingBeginEnd)) {
                        throw new DecodingException("UUDecoder: Missing End after count 0 line");
                    }
                    this.gotEnd = true;
                    return false;
                }
                n = (n2 * 8 + 5) / 6;
                if (string.length() >= n + 1) break block12;
                if (!this.ignoreErrors) break;
            }
            throw new DecodingException("UUDecoder: Short buffer error");
        }
        n = 1;
        while (this.bufsize < n2) {
            byte by = (byte)(string.charAt(n++) - 32 & 0x3F);
            byte by2 = (byte)(string.charAt(n++) - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by << 2 & 0xFC | by2 >>> 4 & 3);
            if (this.bufsize < n2) {
                by = by2;
                by2 = (byte)(string.charAt(n++) - 32 & 0x3F);
                this.buffer[this.bufsize++] = (byte)(by << 4 & 0xF0 | by2 >>> 2 & 0xF);
            }
            if (this.bufsize >= n2) continue;
            by = by2;
            by2 = (byte)(string.charAt(n++) - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by << 6 & 0xC0 | by2 & 0x3F);
        }
        return true;
    }
}

