/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPushInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.Visitor;

public class DCONST
extends Instruction
implements ConstantPushInstruction {
    private double value;

    DCONST() {
    }

    public DCONST(double d) {
        super((short)14, (short)1);
        if (d == 0.0) {
            super.setOpcode((short)14);
        } else if (d == 1.0) {
            super.setOpcode((short)15);
        } else {
            throw new ClassGenException("DCONST can be used only for 0.0 and 1.0: " + d);
        }
        this.value = d;
    }

    @Override
    public Number getValue() {
        return new Double(this.value);
    }

    @Override
    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.DOUBLE;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitPushInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitTypedInstruction(this);
        visitor.visitConstantPushInstruction(this);
        visitor.visitDCONST(this);
    }
}

