/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleProvides
implements Cloneable,
Node {
    private final int provides_index;
    private final int provides_with_count;
    private final int[] provides_with_index;

    ModuleProvides(DataInput dataInput) throws IOException {
        this.provides_index = dataInput.readUnsignedShort();
        this.provides_with_count = dataInput.readUnsignedShort();
        this.provides_with_index = new int[this.provides_with_count];
        for (int i = 0; i < this.provides_with_count; ++i) {
            this.provides_with_index[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleProvides(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.provides_index);
        dataOutputStream.writeShort(this.provides_with_count);
        for (int n : this.provides_with_index) {
            dataOutputStream.writeShort(n);
        }
    }

    public String toString() {
        return "provides(" + this.provides_index + ", " + this.provides_with_count + ", ...)";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.provides_index, (byte)7);
        stringBuilder.append(Utility.compactClassName(string, false));
        stringBuilder.append(", with(").append(this.provides_with_count).append("):\n");
        for (int n : this.provides_with_index) {
            String string2 = constantPool.getConstantString(n, (byte)7);
            stringBuilder.append("      ").append(Utility.compactClassName(string2, false)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public ModuleProvides copy() {
        try {
            return (ModuleProvides)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

