/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleOpens
implements Cloneable,
Node {
    private final int opens_index;
    private final int opens_flags;
    private final int opens_to_count;
    private final int[] opens_to_index;

    ModuleOpens(DataInput dataInput) throws IOException {
        this.opens_index = dataInput.readUnsignedShort();
        this.opens_flags = dataInput.readUnsignedShort();
        this.opens_to_count = dataInput.readUnsignedShort();
        this.opens_to_index = new int[this.opens_to_count];
        for (int i = 0; i < this.opens_to_count; ++i) {
            this.opens_to_index[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleOpens(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.opens_index);
        dataOutputStream.writeShort(this.opens_flags);
        dataOutputStream.writeShort(this.opens_to_count);
        for (int n : this.opens_to_index) {
            dataOutputStream.writeShort(n);
        }
    }

    public String toString() {
        return "opens(" + this.opens_index + ", " + this.opens_flags + ", " + this.opens_to_count + ", ...)";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.opens_index, (byte)20);
        stringBuilder.append(Utility.compactClassName(string, false));
        stringBuilder.append(", ").append(String.format("%04x", this.opens_flags));
        stringBuilder.append(", to(").append(this.opens_to_count).append("):\n");
        for (int n : this.opens_to_index) {
            String string2 = constantPool.getConstantString(n, (byte)19);
            stringBuilder.append("      ").append(Utility.compactClassName(string2, false)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public ModuleOpens copy() {
        try {
            return (ModuleOpens)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

