/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClass
implements Cloneable,
Node {
    private int inner_class_index;
    private int outer_class_index;
    private int inner_name_index;
    private int inner_access_flags;

    public InnerClass(InnerClass innerClass) {
        this(innerClass.getInnerClassIndex(), innerClass.getOuterClassIndex(), innerClass.getInnerNameIndex(), innerClass.getInnerAccessFlags());
    }

    InnerClass(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    public InnerClass(int n, int n2, int n3, int n4) {
        this.inner_class_index = n;
        this.outer_class_index = n2;
        this.inner_name_index = n3;
        this.inner_access_flags = n4;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInnerClass(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.inner_class_index);
        dataOutputStream.writeShort(this.outer_class_index);
        dataOutputStream.writeShort(this.inner_name_index);
        dataOutputStream.writeShort(this.inner_access_flags);
    }

    public int getInnerAccessFlags() {
        return this.inner_access_flags;
    }

    public int getInnerClassIndex() {
        return this.inner_class_index;
    }

    public int getInnerNameIndex() {
        return this.inner_name_index;
    }

    public int getOuterClassIndex() {
        return this.outer_class_index;
    }

    public void setInnerAccessFlags(int n) {
        this.inner_access_flags = n;
    }

    public void setInnerClassIndex(int n) {
        this.inner_class_index = n;
    }

    public void setInnerNameIndex(int n) {
        this.inner_name_index = n;
    }

    public void setOuterClassIndex(int n) {
        this.outer_class_index = n;
    }

    public String toString() {
        return "InnerClass(" + this.inner_class_index + ", " + this.outer_class_index + ", " + this.inner_name_index + ", " + this.inner_access_flags + ")";
    }

    public String toString(ConstantPool constantPool) {
        String string;
        String string2 = constantPool.getConstantString(this.inner_class_index, (byte)7);
        string2 = Utility.compactClassName(string2, false);
        if (this.outer_class_index != 0) {
            string = constantPool.getConstantString(this.outer_class_index, (byte)7);
            string = " of class " + Utility.compactClassName(string, false);
        } else {
            string = "";
        }
        String string3 = this.inner_name_index != 0 ? ((ConstantUtf8)constantPool.getConstant(this.inner_name_index, (byte)1)).getBytes() : "(anonymous)";
        String string4 = Utility.accessToString(this.inner_access_flags, true);
        string4 = string4.isEmpty() ? "" : string4 + " ";
        return "  " + string4 + string3 + "=class " + string2 + string;
    }

    public InnerClass copy() {
        try {
            return (InnerClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

