/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantNameAndType
extends Constant {
    private int name_index;
    private int signature_index;

    public ConstantNameAndType(ConstantNameAndType constantNameAndType) {
        this(constantNameAndType.getNameIndex(), constantNameAndType.getSignatureIndex());
    }

    ConstantNameAndType(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    public ConstantNameAndType(int n, int n2) {
        super((byte)12);
        this.name_index = n;
        this.signature_index = n2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantNameAndType(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.signature_index);
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public String getName(ConstantPool constantPool) {
        return constantPool.constantToString(this.getNameIndex(), (byte)1);
    }

    public int getSignatureIndex() {
        return this.signature_index;
    }

    public String getSignature(ConstantPool constantPool) {
        return constantPool.constantToString(this.getSignatureIndex(), (byte)1);
    }

    public void setNameIndex(int n) {
        this.name_index = n;
    }

    public void setSignatureIndex(int n) {
        this.signature_index = n;
    }

    @Override
    public String toString() {
        return super.toString() + "(name_index = " + this.name_index + ", signature_index = " + this.signature_index + ")";
    }
}

