/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ArchiveURLConnection
extends URLConnection {
    protected String urlString;

    public ArchiveURLConnection(URL url) {
        super(url);
        this.urlString = url.toString();
    }

    protected ArchiveURLConnection(String url) {
        super(null);
        this.urlString = url;
    }

    protected boolean emulateArchiveScheme() {
        return false;
    }

    protected boolean useZipFile() {
        return false;
    }

    public void connect() throws IOException {
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        ZipEntry zipEntry;
        String entry;
        InputStream inputStream;
        int archiveSeparator = this.urlString.indexOf("!/");
        if (archiveSeparator < 0) {
            throw new MalformedURLException("missing archive separators " + this.urlString);
        }
        int start = this.urlString.indexOf(58) + 1;
        if (start > this.urlString.length() || this.urlString.charAt(start) == '/') {
            throw new IllegalArgumentException("archive protocol must be immediately followed by another URL protocol " + this.urlString);
        }
        int i = start;
        int end = this.urlString.indexOf("/") - 1;
        while ((i = this.urlString.indexOf(":", i)) < end) {
            if (this.emulateArchiveScheme()) {
                start = ++i;
                continue;
            }
            if ((archiveSeparator = this.urlString.indexOf("!/", archiveSeparator + 2)) < 0) {
                throw new MalformedURLException("too few archive separators " + this.urlString);
            }
            ++i;
        }
        String nestedURL = this.urlString.substring(start, archiveSeparator);
        int nextArchiveSeparator = this.urlString.indexOf("!/", archiveSeparator + 2);
        if (!this.useZipFile() || !nestedURL.startsWith("file:")) {
            inputStream = this.createInputStream(nestedURL);
        } else {
            entry = nextArchiveSeparator < 0 ? this.urlString.substring(archiveSeparator + 2) : this.urlString.substring(archiveSeparator + 2, nextArchiveSeparator);
            archiveSeparator = nextArchiveSeparator;
            nextArchiveSeparator = this.urlString.indexOf("!/", archiveSeparator + 2);
            final ZipFile zipFile = new ZipFile(nestedURL.substring(5));
            zipEntry = zipFile.getEntry(entry);
            if (zipEntry == null) {
                throw new IOException("archive entry not found " + entry);
            }
            inputStream = new FilterInputStream(zipFile.getInputStream(zipEntry)){

                public void close() throws IOException {
                    super.close();
                    zipFile.close();
                }
            };
        }
        block1: while (archiveSeparator > 0) {
            entry = nextArchiveSeparator < 0 ? this.urlString.substring(archiveSeparator + 2) : this.urlString.substring(archiveSeparator + 2, nextArchiveSeparator);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while (zipInputStream.available() >= 0) {
                zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null) break block1;
                if (!entry.equals(zipEntry.getName())) continue;
                inputStream = zipInputStream;
                archiveSeparator = nextArchiveSeparator;
                nextArchiveSeparator = this.urlString.indexOf("!/", archiveSeparator + 2);
                continue block1;
            }
            break block1;
        }
        return inputStream;
    }

    protected InputStream createInputStream(String nestedURL) throws IOException {
        return new URL(nestedURL).openStream();
    }

    public OutputStream getOutputStream() throws IOException {
        FilterOutputStream filterOutputStream;
        InputStream sourceInputStream;
        block14: {
            int archiveSeparator = this.urlString.indexOf("!/");
            if (archiveSeparator < 0) {
                throw new MalformedURLException("missing archive separator in " + this.urlString);
            }
            int start = this.urlString.indexOf(58) + 1;
            if (start > this.urlString.length() || this.urlString.charAt(start) == '/') {
                throw new IllegalArgumentException("archive protocol must be immediately followed by another URL protocol " + this.urlString);
            }
            int i = start;
            int end = this.urlString.indexOf("/") - 1;
            while ((i = this.urlString.indexOf(":", i)) < end) {
                if (this.emulateArchiveScheme()) {
                    start = ++i;
                    continue;
                }
                if ((archiveSeparator = this.urlString.indexOf("!/", archiveSeparator + 2)) < 0) {
                    throw new MalformedURLException("too few archive separators in " + this.urlString);
                }
                ++i;
            }
            final String nestedURL = this.urlString.substring(start, archiveSeparator);
            final File tempFile = File.createTempFile("Archive", "zip");
            sourceInputStream = null;
            FileOutputStream tempOutputStream = null;
            try {
                ZipOutputStream zipOutputStream;
                tempOutputStream = new FileOutputStream(tempFile);
                try {
                    sourceInputStream = this.createInputStream(nestedURL);
                }
                catch (IOException iOException) {}
                OutputStream outputStream = tempOutputStream;
                InputStream inputStream = sourceInputStream;
                int nextArchiveSeparator = this.urlString.indexOf("!/", archiveSeparator + 2);
                final byte[] bytes = new byte[4096];
                do {
                    String entry = nextArchiveSeparator < 0 ? this.urlString.substring(archiveSeparator + 2) : this.urlString.substring(archiveSeparator + 2, nextArchiveSeparator);
                    zipOutputStream = new ZipOutputStream(outputStream);
                    outputStream = zipOutputStream;
                    ZipInputStream zipInputStream = inputStream == null ? null : new ZipInputStream(inputStream);
                    inputStream = zipInputStream;
                    while (zipInputStream != null && zipInputStream.available() >= 0) {
                        int size;
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (zipEntry == null) break;
                        if (entry.equals(zipEntry.getName())) continue;
                        zipOutputStream.putNextEntry(zipEntry);
                        while ((size = zipInputStream.read(bytes, 0, bytes.length)) > -1) {
                            zipOutputStream.write(bytes, 0, size);
                        }
                    }
                    zipOutputStream.putNextEntry(new ZipEntry(entry));
                    archiveSeparator = nextArchiveSeparator;
                    nextArchiveSeparator = this.urlString.indexOf("!/", archiveSeparator + 2);
                } while (archiveSeparator > 0);
                tempOutputStream = null;
                final boolean deleteRequired = sourceInputStream != null;
                filterOutputStream = new FilterOutputStream(zipOutputStream){
                    protected boolean isClosed;

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void close() throws IOException {
                        OutputStream outputStream;
                        block8: {
                            if (this.isClosed) return;
                            this.isClosed = true;
                            super.close();
                            boolean useRenameTo = nestedURL.startsWith("file:");
                            if (useRenameTo) {
                                File targetFile = new File(nestedURL.substring(5));
                                if (deleteRequired && !targetFile.delete()) {
                                    throw new IOException("cannot delete " + targetFile.getPath());
                                }
                                if (!tempFile.renameTo(targetFile)) {
                                    useRenameTo = false;
                                }
                            }
                            if (useRenameTo) return;
                            FileInputStream inputStream = null;
                            outputStream = null;
                            try {
                                int size;
                                inputStream = new FileInputStream(tempFile);
                                outputStream = ArchiveURLConnection.this.createOutputStream(nestedURL);
                                while ((size = ((InputStream)inputStream).read(bytes, 0, bytes.length)) > -1) {
                                    outputStream.write(bytes, 0, size);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var5_6 = null;
                                if (inputStream != null) {
                                    ((InputStream)inputStream).close();
                                }
                                if (outputStream == null) throw throwable;
                                outputStream.close();
                                throw throwable;
                            }
                            {
                                Object var5_7 = null;
                                if (inputStream == null) break block8;
                            }
                            ((InputStream)inputStream).close();
                        }
                        if (outputStream == null) return;
                        outputStream.close();
                    }
                };
                Object var16_20 = null;
                if (tempOutputStream == null) break block14;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var16_21 = null;
                    if (tempOutputStream != null) {
                        ((OutputStream)tempOutputStream).close();
                    }
                    if (sourceInputStream == null) break block15;
                    sourceInputStream.close();
                }
                throw throwable;
            }
            ((OutputStream)tempOutputStream).close();
        }
        if (sourceInputStream != null) {
            sourceInputStream.close();
        }
        return filterOutputStream;
    }

    protected OutputStream createOutputStream(String nestedURL) throws IOException {
        URL url = new URL(nestedURL.toString());
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDoOutput(true);
        return urlConnection.getOutputStream();
    }
}

