/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class FontCache {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    static FontCache defaultInstance;
    Set<String> fontFamilies = null;
    Map<String, Font> loadedFonts = new HashMap<String, Font>();

    public static FontCache getDefaultInsance() {
        if (defaultInstance == null) {
            defaultInstance = new FontCache();
        }
        return defaultInstance;
    }

    public synchronized Font getFont(String requestedFont) {
        if (this.fontFamilies == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.fontFamilies = new HashSet<String>();
            this.fontFamilies.addAll(Arrays.asList(ge.getAvailableFontFamilyNames()));
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("there are " + this.fontFamilies.size() + " fonts available");
            }
        }
        Font javaFont = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("trying to load " + requestedFont);
        }
        if (this.loadedFonts.containsKey(requestedFont)) {
            return this.loadedFonts.get(requestedFont);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("not already loaded");
        }
        if (this.fontFamilies.contains(requestedFont)) {
            javaFont = new Font(requestedFont, 0, 12);
        } else {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("not a system font");
            }
            javaFont = this.loadFromUrl(requestedFont);
        }
        if (javaFont == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not load font " + requestedFont);
            }
        } else {
            this.loadedFonts.put(requestedFont, javaFont);
        }
        return javaFont;
    }

    Font loadFromUrl(String fontUrl) {
        InputStream is;
        block17: {
            is = null;
            if (fontUrl.startsWith("http") || fontUrl.startsWith("file:")) {
                try {
                    URL url = new URL(fontUrl);
                    is = url.openStream();
                }
                catch (MalformedURLException mue) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Bad url in SLDStyleFactory " + fontUrl + "\n" + mue);
                    }
                    break block17;
                }
                catch (IOException ioe) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("IO error in SLDStyleFactory " + fontUrl + "\n" + ioe);
                    }
                    break block17;
                }
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("not a URL");
            }
            File file = new File(fontUrl);
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException fne) {
                if (!LOGGER.isLoggable(Level.INFO)) break block17;
                LOGGER.info("Bad file name in SLDStyleFactory" + fontUrl + "\n" + fne);
            }
        }
        if (is == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("null input stream, could not load the font");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("about to load");
        }
        try {
            return Font.createFont(0, is);
        }
        catch (FontFormatException ffe) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Font format error in SLDStyleFactory " + fontUrl + "\n" + ffe);
            }
            return null;
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("IO error in SLDStyleFactory " + fontUrl + "\n" + ioe);
            }
            return null;
        }
    }
}

