/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpolateFunction
implements Function {
    public static final String MODE_LINEAR = "linear";
    public static final String MODE_COSINE = "cosine";
    public static final String MODE_CUBIC = "cubic";
    public static final String METHOD_NUMERIC = "numeric";
    public static final String METHOD_COLOR = "color";
    public static final String RASTER_DATA = "Rasterdata";
    private final List<Expression> parameters;
    private final Literal fallback;
    public static final FunctionName NAME = new Name();

    public InterpolateFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public InterpolateFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return "Interpolate";
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Expression lookupExp = this.parameters.get(0);
        Expression currentExp = this.parameters.get(1);
        return (T)currentExp.evaluate(object, context);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Name
    implements FunctionName {
        public int getArgumentCount() {
            return -2;
        }

        public List<String> getArgumentNames() {
            return Arrays.asList("LookupValue", "Data 1", "Value 1", "Data 2", "Value 2", "linear, cosine or cubic", "numeric or color");
        }

        public String getName() {
            return "Interpolate";
        }
    }
}

