/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.encoder;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import ucar.jpeg.jj2000.j2k.codestream.writer.CodestreamWriter;
import ucar.jpeg.jj2000.j2k.codestream.writer.FileCodestreamWriter;
import ucar.jpeg.jj2000.j2k.codestream.writer.HeaderEncoder;
import ucar.jpeg.jj2000.j2k.codestream.writer.PktEncoder;
import ucar.jpeg.jj2000.j2k.encoder.EncoderSpecs;
import ucar.jpeg.jj2000.j2k.entropy.encoder.EntropyCoder;
import ucar.jpeg.jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import ucar.jpeg.jj2000.j2k.fileformat.writer.FileFormatWriter;
import ucar.jpeg.jj2000.j2k.image.BlkImgDataSrc;
import ucar.jpeg.jj2000.j2k.image.ImgData;
import ucar.jpeg.jj2000.j2k.image.ImgDataConverter;
import ucar.jpeg.jj2000.j2k.image.ImgDataJoiner;
import ucar.jpeg.jj2000.j2k.image.Tiler;
import ucar.jpeg.jj2000.j2k.image.forwcomptransf.ForwCompTransf;
import ucar.jpeg.jj2000.j2k.image.input.ImgReader;
import ucar.jpeg.jj2000.j2k.image.input.ImgReaderPGM;
import ucar.jpeg.jj2000.j2k.image.input.ImgReaderPGX;
import ucar.jpeg.jj2000.j2k.image.input.ImgReaderPPM;
import ucar.jpeg.jj2000.j2k.quantization.quantizer.Quantizer;
import ucar.jpeg.jj2000.j2k.roi.encoder.ROIScaler;
import ucar.jpeg.jj2000.j2k.util.CodestreamManipulator;
import ucar.jpeg.jj2000.j2k.util.FacilityManager;
import ucar.jpeg.jj2000.j2k.util.MsgLogger;
import ucar.jpeg.jj2000.j2k.util.ParameterList;
import ucar.jpeg.jj2000.j2k.util.StringFormatException;
import ucar.jpeg.jj2000.j2k.wavelet.analysis.AnWTFilter;
import ucar.jpeg.jj2000.j2k.wavelet.analysis.ForwardWT;

public class Encoder
implements Runnable {
    private int exitCode;
    private ParameterList pl;
    private ParameterList defpl;
    public static final char[] vprfxs = new char[]{'M', 'F', 'W', 'Q', 'R', 'H', 'C', 'A', 'P'};
    private static final String[][] pinfo = new String[][]{{"debug", null, "Print debugging messages when an error is encountered.", "off"}, {"disable_jp2_extension", "[on|off]", "JJ2000 automatically adds .jp2 extension when using 'file_format'option. This option disables it when on.", "off"}, {"file_format", "[on|off]", "Puts the JPEG 2000 codestream in a JP2 file format wrapper.", "off"}, {"pph_tile", "[on|off]", "Packs the packet headers in the tile headers.", "off"}, {"pph_main", "[on|off]", "Packs the packet headers in the main header.", "off"}, {"pfile", "<filename of arguments file>", "Loads the arguments from the specified file. Arguments that are specified on the command line override the ones from the file.\nThe arguments file is a simple text file with one argument per line of the following form:\n  <argument name>=<argument value>\nIf the argument is of boolean type (i.e. its presence turns a feature on), then the 'on' value turns it on, while the 'off' value turns it off. The argument name does not include the '-' or '+' character. Long lines can be broken into several lines by terminating them with ''. Lines starting with '#' are considered as comments. This option is not recursive: any 'pfile' argument appearing in the file is ignored.", null}, {"tile_parts", "<packets per tile-part>", "This option specifies the maximum number of packets to have in one tile-part. 0 means include all packets in first tile-part of each tile", "0"}, {"tiles", "<nominal tile width> <nominal tile height>", "This option specifies the maximum tile dimensions to use. If both dimensions are 0 then no tiling is used.", "0 0"}, {"ref", "<x> <y>", "Sets the origin of the image in the canvas system. It sets the coordinate of the top-left corner of the image reference grid, with respect to the canvas origin", "0 0"}, {"tref", "<x> <y>", "Sets the origin of the tile partitioning on the reference grid, with respect to the canvas origin. The value of 'x' ('y') specified can not be larger than the 'x' one specified in the ref option.", "0 0"}, {"rate", "<output bitrate in bpp>", "This is the output bitrate of the codestream in bits per pixel. When equal to -1, no image information (beside quantization effects) is discarded during compression.\nNote: In the case where '-file_format' option is used, the resulting file may have a larger bitrate.", "-1"}, {"lossless", "[on|off]", "Specifies a lossless compression for the encoder. This options is equivalent to use reversible quantization ('-Qtype reversible') and 5x3 wavelet filters pair ('-Ffilters w5x3'). Note that this option cannot be used with '-rate'. When this option is off, the quantization type and the filters pair is defined by '-Qtype' and '-Ffilters' respectively.", "off"}, {"i", "<image file> [,<image file> [,<image file> ... ]]", "Mandatory argument. This option specifies the name of the input image files. If several image files are provided, they have to be separated by commas in the command line. Supported formats are PGM (raw), PPM (raw) and PGX, which is a simple extension of the PGM file format for single component data supporting arbitrary bitdepths. If the extension is '.pgm', PGM-raw file format is assumed, if the extension is '.ppm', PPM-raw file format is assumed, otherwise PGX file format is assumed. PGM and PPM files are assumed to be 8 bits deep. A multi-component image can be specified by either specifying several PPM and/or PGX files, or by specifying one PPM file.", null}, {"o", "<file name>", "Mandatory argument. This option specifies the name of the output file to which the codestream will be written.", null}, {"verbose", null, "Prints information about the obtained bit stream.", "on"}, {"v", "[on|off]", "Prints version and copyright information.", "off"}, {"u", "[on|off]", "Prints usage information. If specified all other arguments (except 'v') are ignored", "off"}};

    public Encoder(ParameterList pl) {
        this.pl = pl;
        this.defpl = pl.getDefaultParameterList();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean useFileFormat = false;
        boolean pphTile = false;
        boolean pphMain = false;
        boolean tempSop = false;
        boolean tempEph = false;
        try {
            PostCompRateAllocator ralloc;
            FileCodestreamWriter bwriter;
            EntropyCoder ecoder;
            ROIScaler rois;
            Quantizer quant;
            ForwardWT dwt;
            ForwCompTransf fctransf;
            Tiler imgtiler;
            int trefy;
            int trefx;
            int refy;
            int refx;
            int i;
            Object imgsrc;
            int pktspertp;
            float rate;
            boolean verbose;
            try {
                if (this.pl.getBooleanParameter("v")) {
                    this.printVersionAndCopyright();
                }
                if (this.pl.getParameter("u").equals("on")) {
                    this.printUsage();
                    return;
                }
                verbose = this.pl.getBooleanParameter("verbose");
            }
            catch (StringFormatException e) {
                this.error("An error occured while parsing the arguments:\n" + e.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (NumberFormatException e) {
                this.error("An error occured while parsing the arguments:\n" + e.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            if (this.pl.getParameter("i") == null) {
                this.error("Mandatory input file is missing (-i option)", 2);
                return;
            }
            if (this.pl.getParameter("o") == null) {
                this.error("Mandatory output file is missing (-o option)", 2);
                return;
            }
            String outname = this.pl.getParameter("o");
            if (this.pl.getParameter("file_format").equals("on")) {
                useFileFormat = true;
                if (this.pl.getParameter("rate") != null && this.pl.getFloatParameter("rate") != this.defpl.getFloatParameter("rate")) {
                    this.warning("Specified bit-rate applies only on the codestream but not on the whole file.");
                }
            }
            if (useFileFormat) {
                String outext = null;
                String outns = outname;
                if (outname.lastIndexOf(46) != -1) {
                    outext = outname.substring(outname.lastIndexOf(46), outname.length());
                    outns = outname.substring(0, outname.lastIndexOf(46));
                }
                if (!(outext != null && outext.equalsIgnoreCase(".jp2") || this.pl.getBooleanParameter("disable_jp2_extension"))) {
                    FacilityManager.getMsgLogger().printmsg(1, "JPEG 2000 file names end with .jp2 extension when using the file format of part 1. This extension is automatically added by JJ2000. Use '-disable_jp2_extension' to disable it.");
                    outname = outns + ".jp2";
                }
            }
            if (this.pl.getParameter("tiles") == null) {
                this.error("No tiles option specified", 2);
                return;
            }
            if (this.pl.getParameter("pph_tile").equals("on")) {
                pphTile = true;
                if (this.pl.getParameter("Psop").equals("off")) {
                    this.pl.put("Psop", "on");
                    tempSop = true;
                }
                if (this.pl.getParameter("Peph").equals("off")) {
                    this.pl.put("Peph", "on");
                    tempEph = true;
                }
            }
            if (this.pl.getParameter("pph_main").equals("on")) {
                pphMain = true;
                if (this.pl.getParameter("Psop").equals("off")) {
                    this.pl.put("Psop", "on");
                    tempSop = true;
                }
                if (this.pl.getParameter("Peph").equals("off")) {
                    this.pl.put("Peph", "on");
                    tempEph = true;
                }
            }
            if (pphTile && pphMain) {
                this.error("Can't have packed packet headers in both main and tile headers", 2);
            }
            if (this.pl.getBooleanParameter("lossless") && this.pl.getParameter("rate") != null && this.pl.getFloatParameter("rate") != this.defpl.getFloatParameter("rate")) {
                throw new IllegalArgumentException("Cannot use '-rate' and '-lossless' option at  the same time.");
            }
            if (this.pl.getParameter("rate") == null) {
                this.error("Target bitrate not specified", 2);
                return;
            }
            try {
                rate = this.pl.getFloatParameter("rate");
                if (rate == -1.0f) {
                    rate = Float.MAX_VALUE;
                }
            }
            catch (NumberFormatException e) {
                this.error("Invalid value in 'rate' option: " + this.pl.getParameter("rate"), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                pktspertp = this.pl.getIntParameter("tile_parts");
                if (pktspertp != 0) {
                    if (this.pl.getParameter("Psop").equals("off")) {
                        this.pl.put("Psop", "on");
                        tempSop = true;
                    }
                    if (this.pl.getParameter("Peph").equals("off")) {
                        this.pl.put("Peph", "on");
                        tempEph = true;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.error("Invalid value in 'tile_parts' option: " + this.pl.getParameter("tile_parts"), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            StringTokenizer sgtok = new StringTokenizer(this.pl.getParameter("i"), ",");
            int ncomp = 0;
            boolean ppminput = false;
            Vector<ImgReader> imreadervec = new Vector<ImgReader>();
            int nTokens = sgtok.countTokens();
            for (int n = 0; n < nTokens; ++n) {
                String infile = sgtok.nextToken();
                try {
                    if (imreadervec.size() < ncomp) {
                        this.error("With PPM input format only 1 input file can be specified", 2);
                        return;
                    }
                    String inext = infile.lastIndexOf(46) != -1 ? infile.substring(infile.lastIndexOf(46), infile.length()) : null;
                    if (".PGM".equalsIgnoreCase(inext)) {
                        imreadervec.addElement(new ImgReaderPGM(infile));
                        ++ncomp;
                        continue;
                    }
                    if (".PPM".equalsIgnoreCase(inext)) {
                        if (ncomp > 0) {
                            this.error("With PPM input format only 1 input file can be specified", 2);
                            return;
                        }
                        imreadervec.addElement(new ImgReaderPPM(infile));
                        ppminput = true;
                        ncomp += 3;
                        continue;
                    }
                    imreadervec.addElement(new ImgReaderPGX(infile));
                    ++ncomp;
                    continue;
                }
                catch (IOException e) {
                    this.error("Could not open or read from file " + infile + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 3);
                    if (this.pl.getParameter("debug").equals("on")) {
                        e.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                finally {
                    if (this.exitCode != 0) {
                        while (imreadervec.size() > 0) {
                            try {
                                ((ImgReader)imreadervec.elementAt(imreadervec.size() - 1)).close();
                                imreadervec.removeElementAt(imreadervec.size() - 1);
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }
            Object[] imreader = new ImgReader[imreadervec.size()];
            imreadervec.copyInto(imreader);
            imreadervec.removeAllElements();
            imreadervec = null;
            boolean[] imsigned = new boolean[ncomp];
            if (ppminput || ncomp == 1) {
                imgsrc = imreader[0];
                for (i = 0; i < ncomp; ++i) {
                    imsigned[i] = ((ImgReader)imreader[0]).isOrigSigned(i);
                }
            } else {
                int[] imgcmpidxs = new int[ncomp];
                for (i = 0; i < ncomp; ++i) {
                    imsigned[i] = ((ImgReader)imreader[i]).isOrigSigned(0);
                }
                imgsrc = new ImgDataJoiner((BlkImgDataSrc[])imreader, imgcmpidxs);
            }
            StreamTokenizer stok = new StreamTokenizer(new StringReader(this.pl.getParameter("tiles")));
            stok.eolIsSignificant(false);
            stok.nextToken();
            if (stok.ttype != -2) {
                this.error("An error occurred while parsing the tiles option: " + this.pl.getParameter("tiles"), 2);
                return;
            }
            int tw = (int)stok.nval;
            stok.nextToken();
            if (stok.ttype != -2) {
                this.error("An error occurred while parsing the tiles option: " + this.pl.getParameter("tiles"), 2);
                return;
            }
            int th = (int)stok.nval;
            sgtok = new StringTokenizer(this.pl.getParameter("ref"));
            try {
                refx = Integer.parseInt(sgtok.nextToken());
                refy = Integer.parseInt(sgtok.nextToken());
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("Error while parsing 'ref' option");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number type in 'ref' option");
            }
            if (refx < 0 || refy < 0) {
                throw new IllegalArgumentException("Invalid value in 'ref' option ");
            }
            sgtok = new StringTokenizer(this.pl.getParameter("tref"));
            try {
                trefx = Integer.parseInt(sgtok.nextToken());
                trefy = Integer.parseInt(sgtok.nextToken());
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("Error while parsing 'tref' option");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number type in 'tref' option");
            }
            if (trefx < 0 || trefy < 0 || trefx > refx || trefy > refy) {
                throw new IllegalArgumentException("Invalid value in 'tref' option ");
            }
            try {
                imgtiler = new Tiler((BlkImgDataSrc)imgsrc, refx, refy, trefx, trefy, tw, th);
            }
            catch (IllegalArgumentException e) {
                this.error("Could not tile image" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            int ntiles = imgtiler.getNumTiles();
            EncoderSpecs encSpec = new EncoderSpecs(ntiles, ncomp, (BlkImgDataSrc)imgsrc, this.pl);
            if (ppminput && this.pl.getParameter("Mct") != null && this.pl.getParameter("Mct").equals("off")) {
                FacilityManager.getMsgLogger().printmsg(2, "Input image is RGB and no color transform has been specified. Compression performance and image quality might be greatly degraded. Use the 'Mct' option to specify a color transform");
            }
            try {
                fctransf = new ForwCompTransf(imgtiler, encSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Could not instantiate forward component transformation" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            ImgDataConverter converter = new ImgDataConverter(fctransf);
            try {
                dwt = ForwardWT.createInstance(converter, this.pl, encSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Could not instantiate wavelet transform" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                quant = Quantizer.createInstance(dwt, encSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Could not instantiate quantizer" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                rois = ROIScaler.createInstance(quant, this.pl, encSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Could not instantiate ROI scaler" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                ecoder = EntropyCoder.createInstance(rois, this.pl, encSpec.cblks, encSpec.pss, encSpec.bms, encSpec.mqrs, encSpec.rts, encSpec.css, encSpec.sss, encSpec.lcs, encSpec.tts);
            }
            catch (IllegalArgumentException e) {
                this.error("Could not instantiate entropy coder" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                bwriter = new FileCodestreamWriter(outname, Integer.MAX_VALUE);
            }
            catch (IOException e) {
                this.error("Could not open output file" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                ralloc = PostCompRateAllocator.createInstance(ecoder, this.pl, rate, bwriter, encSpec);
            }
            catch (IllegalArgumentException e) {
                this.error("Could not instantiate rate allocator" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    e.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            HeaderEncoder headenc = new HeaderEncoder((ImgData)imgsrc, imsigned, dwt, imgtiler, encSpec, rois, ralloc, this.pl);
            ralloc.setHeaderEncoder(headenc);
            headenc.encodeMainHeader();
            ralloc.initialize();
            headenc.reset();
            headenc.encodeMainHeader();
            ((CodestreamWriter)bwriter).commitBitstreamHeader(headenc);
            if (verbose && this.pl.getFloatParameter("rate") != -1.0f) {
                FacilityManager.getMsgLogger().println("Target bitrate = " + rate + " bpp (i.e. " + (int)(rate * (float)imgsrc.getImgWidth() * (float)imgsrc.getImgHeight() / 8.0f) + " bytes)", 4, 6);
            }
            ralloc.runAndWrite();
            ((CodestreamWriter)bwriter).close();
            int fileLength = ((CodestreamWriter)bwriter).getLength();
            if (pktspertp > 0 || pphTile || pphMain) {
                try {
                    CodestreamManipulator cm = new CodestreamManipulator(outname, ntiles, pktspertp, pphMain, pphTile, tempSop, tempEph);
                    fileLength += cm.doCodestreamManipulation();
                    String res = "";
                    if (pktspertp > 0) {
                        FacilityManager.getMsgLogger().println("Created tile-parts containing at most " + pktspertp + " packets per tile.", 4, 6);
                    }
                    if (pphTile) {
                        FacilityManager.getMsgLogger().println("Moved packet headers to tile headers", 4, 6);
                    }
                    if (pphMain) {
                        FacilityManager.getMsgLogger().println("Moved packet headers to main header", 4, 6);
                    }
                }
                catch (IOException e) {
                    this.error("Error while creating tileparts or packed packet headers" + (e.getMessage() != null ? ":\n" + e.getMessage() : ""), 2);
                    if (this.pl.getParameter("debug").equals("on")) {
                        e.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
            }
            if (useFileFormat) {
                try {
                    int nc = imgsrc.getNumComps();
                    int[] bpc = new int[nc];
                    for (int comp = 0; comp < nc; ++comp) {
                        bpc[comp] = imgsrc.getNomRangeBits(comp);
                    }
                    FileFormatWriter ffw = new FileFormatWriter(outname, imgsrc.getImgHeight(), imgsrc.getImgWidth(), nc, bpc, fileLength);
                    fileLength += ffw.writeFileFormat();
                }
                catch (IOException e) {
                    throw new Error("Error while writing JP2 file format");
                }
            }
            if (verbose) {
                FacilityManager.getMsgLogger().println("Achieved bitrate = " + 8.0f * (float)fileLength / (float)(imgsrc.getImgWidth() * imgsrc.getImgHeight()) + " bpp (i.e. " + fileLength + " bytes)", 4, 6);
                if (this.pl.getParameter("Rroi") != null && !useFileFormat && this.pl.getIntParameter("tile_parts") == 0) {
                    int roiLen = ((CodestreamWriter)bwriter).getOffLastROIPkt();
                    FacilityManager.getMsgLogger().printmsg(1, "The Region Of Interest is encoded in the first " + roiLen + " bytes of the codestream (i.e " + 8.0f * (float)roiLen / (float)(imgsrc.getImgWidth() * imgsrc.getImgHeight()) + " bpp)");
                }
                FacilityManager.getMsgLogger().flush();
            }
            for (i = 0; i < imreader.length; ++i) {
                ((ImgReader)imreader[i]).close();
            }
        }
        catch (IllegalArgumentException e) {
            this.error(e.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            }
            return;
        }
        catch (Error e) {
            this.error("An uncaught error has occurred: " + e.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
        }
        catch (RuntimeException e) {
            this.error("An uncaught runtime exception has occurred: " + e.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
        }
        catch (Throwable e) {
            this.error("An unchecked exception has occurred: " + e.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                e.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public static String[][] getAllParameters() {
        int i;
        Vector<String[]> vec = new Vector<String[]>();
        String[][] str = Encoder.getParameterInfo();
        if (str != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = ForwCompTransf.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = AnWTFilter.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = ForwardWT.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = Quantizer.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = ROIScaler.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = EntropyCoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = HeaderEncoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = PostCompRateAllocator.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = PktEncoder.getParameterInfo()) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                vec.addElement(str[i]);
            }
        }
        if ((str = new String[vec.size()][4]) != null) {
            for (i = str.length - 1; i >= 0; --i) {
                str[i] = (String[])vec.elementAt(i);
            }
        }
        return str;
    }

    private void error(String msg, int code) {
        this.exitCode = code;
        FacilityManager.getMsgLogger().printmsg(3, msg);
    }

    private void warning(String msg) {
        FacilityManager.getMsgLogger().printmsg(2, msg);
    }

    private void printVersionAndCopyright() {
        FacilityManager.getMsgLogger().println("JJ2000's JPEG 2000 Encoder\n", 2, 4);
        FacilityManager.getMsgLogger().println("Version: 5.1\n", 2, 4);
        FacilityManager.getMsgLogger().println("Copyright:\n\nThis software module was originally developed by Rapha\u00ebl Grosbois and Diego Santa Cruz (Swiss Federal Institute of Technology-EPFL); Joel Askel\u00f6f (Ericsson Radio Systems AB); and Bertrand Berthelot, David Bouchard, F\u00e9lix Henry, Gerard Mozelle and Patrice Onno (Canon Research Centre France S.A) in the course of development of the JPEG 2000 standard as specified by ISO/IEC 15444 (JPEG 2000 Standard). This software module is an implementation of a part of the JPEG 2000 Standard. Swiss Federal Institute of Technology-EPFL, Ericsson Radio Systems AB and Canon Research Centre France S.A (collectively JJ2000 Partners) agree not to assert against ISO/IEC and users of the JPEG 2000 Standard (Users) any of their rights under the copyright, not including other intellectual property rights, for this software module with respect to the usage by ISO/IEC and Users of this software module or modifications thereof for use in hardware or software products claiming conformance to the JPEG 2000 Standard. Those intending to use this software module in hardware or software products are advised that their use may infringe existing patents. The original developers of this software module, JJ2000 Partners and ISO/IEC assume no liability for use of this software module or modifications thereof. No license or right to this software module is granted for non JPEG 2000 Standard conforming products. JJ2000 Partners have full right to use this software module for his/her own purpose, assign or donate this software module to any third party and to inhibit third parties from using this software module for non JPEG 2000 Standard conforming products. This copyright notice must be included in all copies or derivative works of this software module.\n\nCopyright (c) 1999/2000 JJ2000 Partners.\n", 2, 4);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    private void printUsage() {
        MsgLogger ml = FacilityManager.getMsgLogger();
        ml.println("Usage:", 0, 0);
        ml.println("JJ2KEncoder args...\n", 10, 12);
        ml.println("The exit code of the encoder is non-zero if an error occurs.\n", 2, 4);
        ml.println("Note: Many encoder modules accept tile-component specific parameters. These parameters must be provided according to the pattern:\n \"[<tile-component idx>] <param>\" (repeated as many time as needed). ", 2, 4);
        ml.println("\n<tile-component idx> respect the following policy according to the degree of priority: \n  (1) t<idx> c<idx> : Tile-component specification.\n  (2) t<idx> : Tile specification.\n  (3) c<idx> : Component specification\n  (4) <void> : Default specification.\n\nWhere the priorities of the specifications are:\n(1) > (2) > (3) > (4), ('>' means \"overrides\")\n", 2, 4);
        ml.println("  <idx>: ',' separates indexes, '-' separates bounds of indexes list. (ex: 0,2-4 means indexes 0,2,3 and  4).\n", 2, 4);
        ml.println("The following arguments are recognized:", 2, 4);
        this.printParamInfo(ml, Encoder.getAllParameters());
        FacilityManager.getMsgLogger().println("\n\n", 0, 0);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    private void printParamInfo(MsgLogger out, String[][] pinfo) {
        if (pinfo == null) {
            return;
        }
        for (int i = 0; i < pinfo.length; ++i) {
            String defval = this.defpl.getParameter(pinfo[i][0]);
            if (defval != null) {
                out.println("-" + pinfo[i][0] + (pinfo[i][1] != null ? " " + pinfo[i][1] + " " : " ") + "(default = " + defval + ")", 4, 8);
            } else {
                out.println("-" + pinfo[i][0] + (pinfo[i][1] != null ? " " + pinfo[i][1] : ""), 4, 8);
            }
            if (pinfo[i][2] == null) continue;
            out.println(pinfo[i][2], 6, 6);
        }
    }
}

