/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.topology;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="SubbasinArea", author="Sven Kralisch", description="Calc the area of the subbasin of a given reach", date="2020-10-25", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class SubbasinArea
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Subbasin HRUs")
    public Attribute.EntityCollection subbasinHRUs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of area attribute in subbasin HRUs", defaultValue="area")
    public Attribute.String areaAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="The area of the sub-basin")
    public Attribute.Double area;

    public void run() {
        double a = 0.0;
        for (Attribute.Entity hru : this.subbasinHRUs.getEntities()) {
            double hruArea = hru.getDouble(this.areaAttributeName.getValue());
            a += hruArea;
        }
        this.area.setValue(a);
    }
}

