/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.soilWater;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitJ2KProcessLumpedSoilWaterStates", author="Peter Krause", description="Initalises the states of the lumpedSoilWater module", version="1.0_0", date="2010-10-29")
public class InitJ2KProcessLumpedSoilWaterStates
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The model entity set")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area", unit="m^2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="field capacity adaptation factor", unit="n/a", lowerBound=0.0, defaultValue="1.0")
    public Attribute.Double FCAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="air capacity adaptation factor", unit="n/a", lowerBound=0.0, defaultValue="1.0")
    public Attribute.Double ACAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU statevar rooting depth", unit="dm", lowerBound=0.0)
    public Attribute.Double rootDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU attribute maximum MPS", unit="L", lowerBound=0.0)
    public Attribute.Double maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU attribute maximum LPS", unit="L", lowerBound=0.0)
    public Attribute.Double maxLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var actual MPS", unit="L", lowerBound=0.0)
    public Attribute.Double actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var actual LPS", unit="L", lowerBound=0.0)
    public Attribute.Double actLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var saturation of MPS", unit="n/a", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var saturation of LPS", unit="n/a", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double satLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var saturation of whole soil", unit="n/a", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double satSoil;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="start saturation of LPS", unit="n/a", lowerBound=0.0, upperBound=1.0, defaultValue="0.0")
    public Attribute.Double satStartLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="start saturation of MPS", unit="n/a", lowerBound=0.0, upperBound=1.0, defaultValue="0.0")
    public Attribute.Double satStartMPS;

    public void init() {
    }

    public void run() {
        Attribute.Entity entity = this.entities.getCurrent();
        double rootDepth = this.rootDepth.getValue();
        double mxMPS = 0.0;
        String aNameFC = "fc_";
        int d = 0;
        while ((double)d < rootDepth) {
            int count = d + 1;
            String mpsDesc = aNameFC + count;
            try {
                double mpsVal = entity.getDouble(mpsDesc);
                mxMPS += mpsVal;
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg(nsae.getMessage() + "\nThis problem typically occurs if the root depht of current land-use is higer than the soil depht.\nPlease provide additional field capacity (fc_*) columns in your soil parameter file or reduce the root depht!");
            }
            ++d;
        }
        mxMPS *= this.area.getValue();
        if ((mxMPS *= this.FCAdaptation.getValue()) == 0.0) {
            mxMPS = 1.0;
        }
        double mxLPS = entity.getDouble("aircap") * this.area.getValue();
        if ((mxLPS *= this.ACAdaptation.getValue()) == 0.0) {
            mxLPS = 1.0;
        }
        if (this.satStartLPS != null) {
            this.actLPS.setValue(mxLPS * this.satStartLPS.getValue());
        }
        if (this.satStartMPS != null) {
            this.actMPS.setValue(mxMPS * this.satStartMPS.getValue());
        }
        this.maxMPS.setValue(mxMPS);
        this.maxLPS.setValue(mxLPS);
        this.satMPS.setValue(this.actMPS.getValue() / mxMPS);
        this.satLPS.setValue(this.actLPS.getValue() / mxLPS);
        this.satSoil.setValue((this.actMPS.getValue() + this.actLPS.getValue()) / (mxMPS + mxLPS));
    }

    public void cleanup() {
    }
}

