/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;

@JAMSComponentDescription(title="WASIMProcessSnow", author="Joerg Schulla, implementation and minor adaptations Peter Krause", description="Adaptation of the WASIM module for snow calculation")
public class WASIMSnow_M1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity area", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity slope aspect correction factor")
    public Attribute.Double sloAspCorrFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity latitude")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity landuse albedo")
    public Attribute.Double landAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Snow water equivalent", unit="mm")
    public Attribute.Double snowWaterEquivalent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="liquid water in snowpack", unit="mm")
    public Attribute.Double freeWater;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="frozen water in snowpack", unit="mm")
    public Attribute.Double iceContent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the snow melt")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the albedo of the entity")
    public Attribute.Double snowAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="melt temperature: temperature atwhich snow melt will start", unit="C")
    public Attribute.Double meltTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="factor c0 for potential melt rate")
    public Attribute.Double c0Factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Free-water holding capacity (decimal percent) of snowpack expressed as decimal fraction of total snowpack water equivalent")
    public Attribute.Double freeWaterCapacity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="constant albedo of snow")
    public Attribute.Double snowConstAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain amount")
    public Attribute.Double rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow amount")
    public Attribute.Double snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="precip amount")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minum temperature", unit="C")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="mean temperature", unit="C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="max temperature", unit="C")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="module active")
    public Attribute.Boolean active;
    double runRain;
    double runSnow;
    double runIceContent;
    double runFreeWater;
    double runSnowWaterEquivalent;
    double runMeltTemperature;
    double runRadiationMeltFactor;
    double runWind;
    double runPrecip;
    double runSnowMelt;
    double runSnowAlbedo;
    double runAET;

    public void init() {
    }

    public void run() {
        if (this.active == null || this.active.getValue()) {
            this.runRain = this.rain.getValue();
            this.runSnow = this.snow.getValue();
            this.runPrecip = this.precip.getValue();
            this.runIceContent = this.iceContent.getValue();
            this.runFreeWater = this.freeWater.getValue();
            this.runSnowWaterEquivalent = this.snowWaterEquivalent.getValue();
            this.runSnowMelt = 0.0;
            this.runSnowAlbedo = this.snowAlbedo.getValue();
            this.runMeltTemperature = this.meltTemp.getValue();
            double tempDay = (this.tmax.getValue() + this.tmean.getValue()) / 2.0;
            double tempNight = (this.tmin.getValue() + this.tmean.getValue()) / 2.0;
            if (this.runSnow > 0.0 || this.runSnowWaterEquivalent > 0.0) {
                int julDay = this.time.get(6);
                double dayFrac = DailySolarRadiationCalculationMethods.calcDayFraction(this.latitude.getValue(), julDay);
                double potMeltRate = this.calcAccumulationAndMelt(tempDay, dayFrac);
                potMeltRate += this.calcAccumulationAndMelt(tempNight, 1.0 - dayFrac);
                potMeltRate *= this.area.getValue();
                this.runRain = 0.0;
                this.runSnow = 0.0;
                if (potMeltRate > this.runIceContent) {
                    potMeltRate = this.runIceContent;
                }
                this.runIceContent -= potMeltRate;
                this.runFreeWater += potMeltRate;
                double maxFreeWater = this.runIceContent * this.freeWaterCapacity.getValue();
                if (maxFreeWater < this.runFreeWater) {
                    this.runSnowMelt = this.runFreeWater - maxFreeWater;
                    this.runFreeWater = maxFreeWater;
                }
                this.runSnowAlbedo = this.runIceContent + this.runFreeWater > 5.0 * this.area.getValue() ? this.snowConstAlbedo.getValue() : this.landAlbedo.getValue();
            }
            this.iceContent.setValue(this.runIceContent);
            this.freeWater.setValue(this.runFreeWater);
            this.snowWaterEquivalent.setValue(this.runIceContent + this.runFreeWater);
            this.snowMelt.setValue(this.runSnowMelt);
            this.snowAlbedo.setValue(this.runSnowAlbedo);
            this.rain.setValue(this.runRain);
            this.snow.setValue(this.runSnow);
        }
    }

    public void cleanup() {
    }

    private double calcAccumulationAndMelt(double temperature, double dayFraction) {
        this.runIceContent += this.runSnow * dayFraction;
        this.runFreeWater += this.runRain * dayFraction;
        double potMeltRate = 0.0;
        potMeltRate = this.runIceContent > 0.0 ? this.c0Factor.getValue() * (temperature - this.runMeltTemperature) : 0.0;
        return potMeltRate * dayFraction;
    }
}

