/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcRainSnowParts", author="Peter Krause", description="Distributes precipitation into rain and snow based on air temperature", version="1.0_0", date="2011-05-30")
public class CalcRainSnowParts
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute name area", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Snow parameter TRS", lowerBound=-10.0, upperBound=10.0, defaultValue="0.0", unit="\u00b0C")
    public Attribute.Double snow_trs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Snow parameter TRANS", lowerBound=0.0, upperBound=5.0, defaultValue="2.0", unit="K")
    public Attribute.Double snow_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable min temperature or mean", unit="\u00b0C")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable precipitation", unit="mm")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="state variable rain", unit="L")
    public Attribute.Double rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="state variable snow", unit="L")
    public Attribute.Double snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="save variable rain", defaultValue="0", unit="L")
    public Attribute.Double svRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="save variable snow", defaultValue="0", unit="L")
    public Attribute.Double svSnow;

    public void init() {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double temperature = (this.tmin.getValue() + this.tmean.getValue()) / 2.0;
        double pSnow = (this.snow_trs.getValue() + this.snow_trans.getValue() - temperature) / (2.0 * this.snow_trans.getValue());
        if (pSnow > 1.0) {
            pSnow = 1.0;
        } else if (pSnow < 0.0) {
            pSnow = 0.0;
        }
        double precip = this.precip.getValue() * this.area.getValue();
        if (precip < 0.0) {
            precip = 0.0;
        }
        double rain = (1.0 - pSnow) * precip;
        double snow = pSnow * precip;
        this.snow.setValue(snow);
        this.rain.setValue(rain);
        this.svRain.setValue(rain);
        this.svSnow.setValue(snow);
    }

    public void cleanup() {
    }
}

