/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessRouting", author="Peter Krause", description="Passes the output of the entities as input to the respective reach or unit", version="1.0_0", date="2011-05-30")
public class J2KProcessRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The spatial modelling entities")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reservoir objects")
    public Attribute.EntityCollection reservoirs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD1 inflow to modelling entity", unit="L")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD2 inflow to modelling entity", unit="L")
    public Attribute.Double inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG1 inflow to modelling entity", unit="L")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG2 inflow to modelling entity", unit="L")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="groundwater excess as input to modelling entity", unit="L", defaultValue="0")
    public Attribute.Double inGWExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD1 outflow from modellig entity", unit="L")
    public Attribute.Double outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD2 outflow from modellig entity", unit="L")
    public Attribute.Double outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG1 outflow from modellig entity", unit="L")
    public Attribute.Double outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG2 outflow from modellig entity", unit="L")
    public Attribute.Double outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Downstream hru entity")
    public Attribute.Entity toPoly;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Downstream reach entity")
    public Attribute.Entity toReach;

    public void init() {
    }

    public void run() {
        Attribute.Entity entity = this.entities.getCurrent();
        Attribute.Entity toReservoir = null;
        toReservoir = entity.existsAttribute("to_reservoir") ? (Attribute.Entity)entity.getObject("to_reservoir") : null;
        double RD1out = this.outRD1.getValue();
        double RD2out = this.outRD2.getValue();
        double RG1out = this.outRG1.getValue();
        double RG2out = this.outRG2.getValue();
        if (!this.toPoly.isEmpty()) {
            double elev = this.toPoly.getDouble("slope");
            double RD1in = this.toPoly.getDouble("inRD1");
            double RD2in = this.toPoly.getDouble("inRD2");
            double RG1in = this.toPoly.getDouble("inRG1");
            double RG2in = this.toPoly.getDouble("inRG2");
            RD1in += RD1out;
            RD2in += RD2out;
            RG1in += RG1out;
            RG2in += RG2out;
            RD2in += this.inGWExcess.getValue();
            RD1out = 0.0;
            RD2out = 0.0;
            RG1out = 0.0;
            RG2out = 0.0;
            this.outRD1.setValue(0.0);
            this.outRD2.setValue(0.0);
            this.outRG1.setValue(0.0);
            this.outRG2.setValue(0.0);
            this.inGWExcess.setValue(0.0);
            this.toPoly.setDouble("inRD1", RD1in);
            this.toPoly.setDouble("inRD2", RD2in);
            this.toPoly.setDouble("inRG1", RG1in);
            this.toPoly.setDouble("inRG2", RG2in);
        } else if (!this.toReach.isEmpty()) {
            double RD1in = this.toReach.getDouble("inRD1");
            double RD2in = this.toReach.getDouble("inRD2");
            double RG1in = this.toReach.getDouble("inRG1");
            double RG2in = this.toReach.getDouble("inRG2");
            RD1in += RD1out;
            RD2in += RD2out;
            RG1in += RG1out;
            RG2in += RG2out;
            RD2in += this.inGWExcess.getValue();
            RD1out = 0.0;
            RD2out = 0.0;
            RG1out = 0.0;
            RG2out = 0.0;
            this.outRD1.setValue(RD1out);
            this.toReach.setDouble("inRD1", RD1in);
            this.outRD2.setValue(RD2out);
            this.toReach.setDouble("inRD2", RD2in);
            this.outRG1.setValue(RG1out);
            this.toReach.setDouble("inRG1", RG1in);
            this.outRG2.setValue(RG2out);
            this.inGWExcess.setValue(0.0);
            this.toReach.setDouble("inRG2", RG2in);
        } else if (toReservoir != null) {
            double resRD1 = toReservoir.getDouble("compRD1");
            double resRD2 = toReservoir.getDouble("compRD2");
            double resRG1 = toReservoir.getDouble("compRG1");
            double resRG2 = toReservoir.getDouble("compRG2");
            resRD1 += RD1out;
            resRD2 += RD2out;
            resRG1 += RG1out;
            resRG2 += RG2out;
            RD1out = 0.0;
            RD2out = 0.0;
            RG1out = 0.0;
            RG2out = 0.0;
            this.outRD1.setValue(RD1out);
            toReservoir.setDouble("compRD1", resRD1);
            this.outRD2.setValue(RD2out);
            toReservoir.setDouble("compRD2", resRD2);
            this.outRG1.setValue(RG1out);
            toReservoir.setDouble("compRG1", resRG1);
            this.outRG2.setValue(RG2out);
            toReservoir.setDouble("compRG2", resRG2);
        } else {
            this.getModel().getRuntime().println("Current entity ID: " + (int)entity.getDouble("ID") + " has no receiver.");
        }
    }

    public void cleanup() {
    }
}

