/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.physicalCalculations;

public class ClimatologicalVariables {
    public static double calc_absTemp(double temperature, String unit) {
        double T0 = 273.15;
        double absTemp = 0.0;
        if (unit.equals("degC")) {
            absTemp = temperature + T0;
        } else if (unit.equals("F")) {
            absTemp = (temperature - 32.0) * 0.0 + T0;
        }
        return absTemp;
    }

    public static double calc_saturationVapourPressure(double temperature) {
        double es_T = 0.6108 * Math.exp(17.27 * temperature / (237.3 + temperature));
        return es_T;
    }

    public static double calc_vapourPressure(double rhum, double es_T) {
        double ea = es_T * (rhum / 100.0);
        return ea;
    }

    public static double calc_maxHum(double temperature) {
        double esT = ClimatologicalVariables.calc_saturationVapourPressure(temperature);
        esT = 10.0 * esT;
        double mH = esT * 216.7 / (temperature + 273.15);
        return mH;
    }

    public static double calc_latentHeatOfVaporization(double temperature) {
        double L = (2501.0 - 2.361 * temperature) / 1000.0;
        return L;
    }

    public static double calc_psyConst(double pZ, double L) {
        double CP = 0.001013;
        double VM = 0.622;
        double psy = CP * pZ / (VM * L);
        return psy;
    }

    public static double calc_atmosphericPressure(double elevation, double tabs) {
        double pZ = 1013.0 * Math.exp(-1.0 * (9.811 / (8314.3 * tabs) * elevation));
        return pZ / 10.0;
    }

    public static double calc_slopeOfSaturationPressureCurve(double temperature) {
        double sospc = 4098.0 * (0.6108 * Math.exp(17.27 * temperature / (temperature + 237.3))) / ((temperature + 237.3) * (temperature + 237.3));
        return sospc;
    }

    public static double calc_VirtualTemperature(double tabs, double pz, double ea) {
        double vt = tabs / (1.0 - 0.378 * (ea / pz));
        return vt;
    }

    public static double calc_AirDensityAtConstantPressure(double virtTemp, double P) {
        double da = 3.486 * (P / virtTemp);
        return da;
    }
}

