/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JAMSComponentDescription(title="SubbasinLink", author="Sven Kralisch", description="Calculates (unnested) subbasin area and related HRU list for each reach", date="2021-10-24", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class SubbasinLink
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hrus")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of reaches")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of sub-basin attribute in HRUs", defaultValue="subbasin")
    public Attribute.String subbasinAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of area attribute in HRUs", defaultValue="area")
    public Attribute.String areaAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of sub-basin area attribute in reaches", defaultValue="area")
    public Attribute.String subbasinAreaAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Store list of HRUs that belong to current subbasin?", defaultValue="false")
    public Attribute.Boolean storeSubbasinHRUs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of HRU collection attribute in reaches", defaultValue="subbasinHRUs")
    public Attribute.String subbasinHRUsAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="to_poly")
    public Attribute.String hru2hruAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String hru2reachAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Auto-detect subbasin ID if not existing? This is a workaround for old J2K parameter files without \"subbasin\" attribute.", defaultValue="true")
    public Attribute.Boolean autoSubbasin;
    private Map<Attribute.Entity, List<Attribute.Entity>> reach2hruMap = new HashMap<Attribute.Entity, List<Attribute.Entity>>();

    public void init() {
        if (this.autoSubbasin.getValue() && !((Attribute.Entity)this.hrus.getEntities().get(0)).existsAttribute(this.subbasinAttributeName.getValue())) {
            List hruList = this.hrus.getEntities();
            for (int i = hruList.size() - 1; i >= 0; --i) {
                Attribute.Entity entity = (Attribute.Entity)hruList.get(i);
                Attribute.Entity toReach = (Attribute.Entity)entity.getObject(this.hru2reachAttributeName.getValue());
                Attribute.Entity toHRU = (Attribute.Entity)entity.getObject(this.hru2hruAttributeName.getValue());
                if (toReach.getId() != -1L) {
                    entity.setDouble(this.subbasinAttributeName.getValue(), (double)toReach.getId());
                    continue;
                }
                if (toHRU.getId() == -1L) continue;
                if (toHRU.existsAttribute(this.subbasinAttributeName.getValue())) {
                    entity.setDouble(this.subbasinAttributeName.getValue(), toHRU.getDouble(this.subbasinAttributeName.getValue()));
                    continue;
                }
                this.getModel().getRuntime().println("Problem: No subbbasin found for HRU " + entity.getId());
            }
        }
        HashMap<Long, Attribute.Entity> reachMap = new HashMap<Long, Attribute.Entity>();
        for (Attribute.Entity entity : this.reaches.getEntities()) {
            reachMap.put(entity.getId(), entity);
        }
        for (Attribute.Entity entity : this.hrus.getEntities()) {
            double subbasinID = entity.getDouble(this.subbasinAttributeName.getValue());
            Attribute.Entity reach = (Attribute.Entity)reachMap.get((long)subbasinID);
            List<Attribute.Entity> hruList = this.reach2hruMap.get(reach);
            if (hruList == null) {
                hruList = new ArrayList<Attribute.Entity>();
                this.reach2hruMap.put(reach, hruList);
            }
            hruList.add(entity);
        }
        for (Map.Entry entry : this.reach2hruMap.entrySet()) {
            Attribute.Entity reach = (Attribute.Entity)entry.getKey();
            List hrus = (List)entry.getValue();
            double area = 0.0;
            for (Attribute.Entity hru : hrus) {
                area += hru.getDouble(this.areaAttributeName.getValue());
            }
            reach.setDouble(this.areaAttributeName.getValue(), area);
            if (!this.storeSubbasinHRUs.getValue()) continue;
            reach.setObject(this.subbasinHRUsAttributeName.getValue(), (Object)hrus);
        }
    }

    public void run() {
    }

    public void cleanup() {
    }
}

