/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.statistics.IDW;

@JAMSComponentDescription(title="RainCorrectionSevruk", author="Peter Krause", description="Applies correction according to RICHTER 1985 and SEVRUK 1989for measured daily precip sums. RICHTER is used for wetting and ET losseswhereas SEVRUK is used for the wind correction. This routine is thoughtto produce better results in alpine regions than the normal RICHTER correction")
public class RainCorrectionSevruk
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the precip values")
    public Attribute.DoubleArray precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temperature for the correction function")
    public Attribute.DoubleArray temperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="wind speed for the correction function")
    public Attribute.DoubleArray wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="corrected precip values")
    public Attribute.DoubleArray rcorr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of temperature station elevations")
    public Attribute.DoubleArray tempElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of temperature station's x coordinate")
    public Attribute.DoubleArray tempXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of temperature station's y coordinate")
    public Attribute.DoubleArray tempYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Regression coefficients for temperature")
    public Attribute.DoubleArray tempRegCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of precip station elevations")
    public Attribute.DoubleArray rainElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of precip station's x coordinate")
    public Attribute.DoubleArray rainXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of precip station's y coordinate")
    public Attribute.DoubleArray rainYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of wind station elevations")
    public Attribute.DoubleArray windElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of wind station's x coordinate")
    public Attribute.DoubleArray windXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of wind station's y coordinate")
    public Attribute.DoubleArray windYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Regression coefficients for wind")
    public Attribute.DoubleArray windRegCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of temperature station for IDW")
    public Attribute.Integer tempNIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of wind station for IDW")
    public Attribute.Integer windNIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="power for IDW function")
    public Attribute.Double pIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="regression threshold")
    public Attribute.Double regThres;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="tbase")
    public Attribute.Double tbase;
    IDW idwTemp = new IDW();
    IDW idwWind = new IDW();

    public void run() {
        double[] precip = this.precip.getValue();
        double[] temperature = this.temperature.getValue();
        double[] wind = this.wind.getValue();
        int n = precip.length;
        double[] rcorr = this.rcorr.getValue();
        if (rcorr == null || rcorr.length != n) {
            rcorr = new double[n];
        }
        double[] rainElev = this.rainElevation.getValue();
        double[] rainX = this.rainXCoord.getValue();
        double[] rainY = this.rainYCoord.getValue();
        double rsqTemp = this.tempRegCoeff.getValue()[2];
        double gradTemp = this.tempRegCoeff.getValue()[1];
        double rsqWind = this.tempRegCoeff.getValue()[2];
        double gradWind = this.tempRegCoeff.getValue()[1];
        this.idwTemp.init(this.tempXCoord.getValue(), this.tempYCoord.getValue(), this.tempElevation.getValue(), (int)this.pIDW.getValue(), IDW.Projection.ANY);
        this.idwWind.init(this.windXCoord.getValue(), this.windYCoord.getValue(), this.windElevation.getValue(), (int)this.pIDW.getValue(), IDW.Projection.ANY);
        for (int r = 0; r < n; ++r) {
            double rainTemp = 0.0;
            double rainWind = 0.0;
            rainTemp = rsqTemp > this.regThres.getValue() ? this.idwTemp.getElevationCorrectedIDW(rainX[r], rainY[r], rainElev[r], gradTemp, temperature, this.tempNIDW.getValue()) : this.idwTemp.getIDW(rainX[r], rainY[r], temperature, this.tempNIDW.getValue());
            rainWind = rsqWind > this.regThres.getValue() ? this.idwWind.getElevationCorrectedIDW(rainX[r], rainY[r], rainElev[r], gradWind, wind, this.windNIDW.getValue()) : this.idwWind.getIDW(rainX[r], rainY[r], temperature, this.windNIDW.getValue());
            double windErr = 0.0;
            if (rainTemp < -27.0) {
                windErr = 1.0 + 0.55 * Math.pow(rainWind, 1.4);
            } else if (rainTemp >= -27.0 && rainTemp < -8.0) {
                windErr = 1.0 + 0.28 * Math.pow(rainWind, 1.3);
            } else if (rainTemp >= -8.0 && rainTemp <= this.tbase.getValue()) {
                windErr = 1.0 + 0.15 * Math.pow(rainWind, 1.18);
            } else if (rainTemp >= this.tbase.getValue()) {
                windErr = 1.0 + 0.015 * rainWind;
            }
            double wetErr = 0.0;
            wetErr = precip[r] < 0.1 ? 0.0 : (this.time.get(2) >= 4 & this.time.get(2) < 10 ? (precip[r] >= 9.0 ? 0.47 : 0.08 * Math.log(precip[r]) + 0.225) : (precip[r] >= 9.0 ? 0.3 : 0.05 * Math.log(precip[r]) + 0.13));
            rcorr[r] = precip[r] + precip[r] * windErr + wetErr;
        }
        this.rcorr.setValue(rcorr);
    }
}

