/*
 * Decompiled with CFR 0.152.
 */
package jams.logging;

import jams.JAMS;
import jams.logging.MessageBoxWithDetailsDlg;
import java.awt.Frame;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class MsgBoxLogHandler
extends Handler {
    private static final HashSet<Level> msgDialogHandling = new HashSet();
    private static final HashMap<Level, String> msgDialogTitle = new HashMap();
    private static final HashMap<Level, Integer> msgDialogIcon = new HashMap();
    private Frame parent;
    static final MsgBoxLogHandler instance = new MsgBoxLogHandler();

    public static MsgBoxLogHandler getInstance() {
        return instance;
    }

    private MsgBoxLogHandler() {
        msgDialogHandling.add(Level.INFO);
        msgDialogHandling.add(Level.SEVERE);
        msgDialogHandling.add(Level.WARNING);
        msgDialogTitle.put(Level.OFF, "");
        msgDialogTitle.put(Level.ALL, "General_information");
        msgDialogTitle.put(Level.CONFIG, "Configuration");
        msgDialogTitle.put(Level.FINE, "Information");
        msgDialogTitle.put(Level.FINER, "Information");
        msgDialogTitle.put(Level.FINEST, "Information");
        msgDialogTitle.put(Level.INFO, "Information");
        msgDialogTitle.put(Level.SEVERE, "Error");
        msgDialogTitle.put(Level.WARNING, "Warning");
        msgDialogIcon.put(Level.OFF, 1);
        msgDialogIcon.put(Level.ALL, 1);
        msgDialogIcon.put(Level.CONFIG, 1);
        msgDialogIcon.put(Level.FINE, 1);
        msgDialogIcon.put(Level.FINER, 1);
        msgDialogIcon.put(Level.FINEST, 1);
        msgDialogIcon.put(Level.INFO, 1);
        msgDialogIcon.put(Level.SEVERE, 0);
        msgDialogIcon.put(Level.WARNING, 2);
    }

    @Override
    public void publish(LogRecord record) {
        if (msgDialogHandling.contains(record.getLevel())) {
            if (record.getThrown() != null) {
                StringWriter w = new StringWriter();
                if (record.getThrown().getCause() != null) {
                    record.setThrown(record.getThrown().getCause());
                }
                record.getThrown().printStackTrace(new PrintWriter(w));
                MessageBoxWithDetailsDlg.showMessageBoxWithDetails(this.parent, record.getMessage() == null ? record.getThrown().toString() : record.getMessage(), JAMS.i18n(msgDialogTitle.get(record.getLevel())), w.toString(), msgDialogIcon.get(record.getLevel()));
                try {
                    w.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else {
                MessageBoxWithDetailsDlg.showMessageBoxWithDetails(this.parent, record.getMessage(), JAMS.i18n(msgDialogTitle.get(record.getLevel())), null, msgDialogIcon.get(record.getLevel()));
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

