/*
 * Decompiled with CFR 0.152.
 */
package jams.logging;

import jams.gui.tools.GUIHelper;
import jams.tools.JAMSTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MessageBoxWithDetailsDlg
extends JDialog {
    String message;
    String title;
    String details;
    JTextArea messageLabel = new JTextArea();
    JButton detailsButton = new JButton("View Details >>");
    JButton okButton = new JButton("OK");
    JTextArea detailsArea = new JTextArea(20, 40);
    JScrollPane detailsPane = new JScrollPane(this.detailsArea);
    int icon = -1;

    private MessageBoxWithDetailsDlg(Component parent, String message, String title, String details, int icon) {
        super(GUIHelper.findWindow(parent), title);
        this.setIconImages(JAMSTools.getJAMSIcons());
        this.setAlwaysOnTop(true);
        this.setLocationByPlatform(true);
        this.setModal(true);
        this.message = message;
        this.title = title;
        this.details = details;
        this.icon = icon;
        this.detailsButton.putClientProperty("state", false);
        this.detailsPane.setVisible(false);
        this.detailsArea.setText(this.details);
        this.detailsArea.setFont(new Font("Arial", 0, 10));
        this.messageLabel.setText(message);
        this.initGUI();
        this.initActions();
        this.pack();
    }

    private void initGUI() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel eastPanel = new JPanel(new BorderLayout());
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel southPanel = new JPanel(new FlowLayout(2));
        outerPanel.add((Component)mainPanel, "North");
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)eastPanel, "West");
        centerPanel.add((Component)southPanel, "South");
        centerPanel.add((Component)this.messageLabel, "Center");
        southPanel.add(this.okButton);
        if (this.details != null) {
            southPanel.add(this.detailsButton);
        }
        outerPanel.add((Component)this.detailsPane, "South");
        this.detailsPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 6, 40, 6), BorderFactory.createEtchedBorder()));
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel iconLabel = new JLabel();
        eastPanel.add(iconLabel);
        switch (this.icon) {
            case 1: {
                iconLabel.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
                break;
            }
            case 2: {
                iconLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                break;
            }
            case 0: {
                iconLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                break;
            }
            case 3: {
                iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
                break;
            }
        }
        if (iconLabel.getIcon() != null) {
            iconLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 4));
        }
        iconLabel.setVerticalAlignment(1);
        this.add(outerPanel);
        Dimension dMin = this.getMinimumSize();
        dMin.width = Math.min(Math.max(dMin.width, 460), 1000);
        this.setMinimumSize(dMin);
        this.messageLabel.setLineWrap(true);
        this.messageLabel.setEnabled(false);
        this.messageLabel.setOpaque(false);
        this.messageLabel.setRows(this.messageLabel.getLineCount());
    }

    private void initActions() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBoxWithDetailsDlg.this.setVisible(false);
            }
        });
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)MessageBoxWithDetailsDlg.this.detailsButton.getClientProperty("state");
                MessageBoxWithDetailsDlg.this.detailsPane.setVisible(!state);
                MessageBoxWithDetailsDlg.this.detailsButton.putClientProperty("state", !state);
                MessageBoxWithDetailsDlg.this.pack();
            }
        });
    }

    public static MessageBoxWithDetailsDlg showMessageBoxWithDetails(Component parent, String message, String title, String details, int icon) {
        MessageBoxWithDetailsDlg msgBox = new MessageBoxWithDetailsDlg(parent, message, title, details, icon);
        GUIHelper.centerOnParent(msgBox, true);
        msgBox.setVisible(true);
        return msgBox;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MessageBoxWithDetailsDlg.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MessageBoxWithDetailsDlg.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MessageBoxWithDetailsDlg.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MessageBoxWithDetailsDlg.class.getName()).log(Level.SEVERE, null, ex);
        }
        MessageBoxWithDetailsDlg.showMessageBoxWithDetails(null, "test-test-test-test-test-test-test-test-test test-test-test-test-test-test-test-test-test test-test-test-test-testest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testtest-test test-test-test-test-test-test-test-test-test test-test-test-test-test-testt-test-test-test-test test-test-test-test-test-test-test-test-test", "my title", "some details-some detailssome details-blabla-blabla-blabla", 0);
        System.exit(0);
    }
}

