/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSTimeInterval;
import jams.gui.input.CalendarInput;
import jams.gui.input.InputComponent;
import jams.gui.input.ValueChangeListener;
import jams.gui.tools.GUIHelper;
import jams.tools.StringTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TimeintervalInput
extends JPanel
implements InputComponent {
    private JTextField tuCount;
    private JComboBox timeUnit;
    private Map<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> fieldMap = new HashMap<Integer, Integer>();
    private JPanel panel;
    private ValueChangeListener l;
    private CalendarInput startDate;
    private CalendarInput endDate;
    private Color oldColor;

    public TimeintervalInput() {
        this(false);
    }

    public TimeintervalInput(boolean intervalEdit) {
        GridBagLayout gbl = new GridBagLayout();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(gbl);
        GUIHelper.addGBComponent(this, gbl, new JLabel(JAMS.i18n("Start:_")), 0, 1, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, gbl, new JLabel(JAMS.i18n("End:_")), 0, 2, 1, 1, 0.0, 0.0);
        this.startDate = new CalendarInput(false);
        GUIHelper.addGBComponent(this, gbl, this.startDate.getDatePanel(), 1, 1, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, gbl, this.startDate.getTimePanel(), 11, 1, 1, 1, 0.0, 0.0);
        this.startDate.getTimeText().setToolTipText(JAMS.i18n("Starttime"));
        this.startDate.getDateText().setToolTipText(JAMS.i18n("Startdate"));
        this.endDate = new CalendarInput(false);
        GUIHelper.addGBComponent(this, gbl, this.endDate.getDatePanel(), 1, 2, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, gbl, this.endDate.getTimePanel(), 11, 2, 1, 1, 0.0, 0.0);
        this.endDate.getTimeText().setToolTipText(JAMS.i18n("Endtime"));
        this.endDate.getDateText().setToolTipText(JAMS.i18n("Enddate"));
        this.indexMap.put(1, 0);
        this.indexMap.put(2, 1);
        this.indexMap.put(6, 2);
        this.indexMap.put(11, 3);
        this.indexMap.put(12, 4);
        this.indexMap.put(13, 5);
        this.fieldMap.put(0, 1);
        this.fieldMap.put(1, 2);
        this.fieldMap.put(2, 6);
        this.fieldMap.put(3, 11);
        this.fieldMap.put(4, 12);
        this.fieldMap.put(5, 13);
        this.timeUnit = new JComboBox();
        this.timeUnit.addItem(JAMS.i18n("YEAR"));
        this.timeUnit.addItem(JAMS.i18n("MONTH"));
        this.timeUnit.addItem(JAMS.i18n("DAY"));
        this.timeUnit.addItem(JAMS.i18n("HOUR"));
        this.timeUnit.addItem(JAMS.i18n("MINUTE"));
        this.timeUnit.addItem(JAMS.i18n("SECOND"));
        this.timeUnit.setPreferredSize(new Dimension(40, 20));
        this.tuCount = new JTextField();
        this.tuCount.setInputVerifier(new NumericIntervalVerifier(0.0, 1000.0));
        this.tuCount.setPreferredSize(new Dimension(40, 20));
        if (intervalEdit) {
            GUIHelper.addGBComponent(this, gbl, new JLabel(JAMS.i18n("Unit:_")), 0, 3, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this, gbl, new JLabel(JAMS.i18n("Unit_Count:_")), 0, 4, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this, gbl, this.timeUnit, 1, 3, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this, gbl, this.tuCount, 1, 4, 1, 1, 0.0, 0.0);
        }
    }

    @Override
    public String getValue() {
        Attribute.TimeInterval ti = this.getTimeInterval();
        if (ti != null) {
            return ti.toString();
        }
        return null;
    }

    public Attribute.TimeInterval getTimeInterval() {
        JAMSTimeInterval ti = new JAMSTimeInterval();
        ti.setStart(this.startDate.getCalendarValue());
        ti.setEnd(this.endDate.getCalendarValue());
        if (this.timeUnit.getSelectedIndex() != -1) {
            ti.setTimeUnit(this.fieldMap.get(this.timeUnit.getSelectedIndex()));
        }
        if (this.tuCount.getText().compareTo("") != 0) {
            ti.setTimeUnitCount(Integer.parseInt(this.tuCount.getText()));
        }
        if (ti.getStart() == null) {
            return null;
        }
        if (ti.getEnd() == null) {
            return null;
        }
        if (!ti.getStart().before(ti.getEnd())) {
            return null;
        }
        return ti;
    }

    @Override
    public void setValue(String value) {
        JAMSTimeInterval ti = new JAMSTimeInterval();
        if (!StringTools.isEmptyString(value)) {
            ti.setValue(value);
        }
        Attribute.Calendar start = ti.getStart();
        this.startDate.setValue(start);
        Attribute.Calendar end = ti.getEnd();
        this.endDate.setValue(end);
        this.timeUnit.setSelectedIndex(this.indexMap.get(ti.getTimeUnit()));
        this.tuCount.setText(Integer.toString(ti.getTimeUnitCount()));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setRange(double lower, double upper) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.startDate.setEnabled(enabled);
        this.endDate.setEnabled(enabled);
        this.timeUnit.setEnabled(enabled);
        this.tuCount.setEnabled(enabled);
    }

    @Override
    public boolean verify() {
        try {
            return this.getValue() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    @Override
    public void setLength(int length) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener l) {
        this.l = l;
        this.startDate.addValueChangeListener(l);
        this.endDate.addValueChangeListener(l);
        this.timeUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeintervalInput.this.l.valueChanged();
            }
        });
        this.tuCount.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TimeintervalInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TimeintervalInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TimeintervalInput.this.l.valueChanged();
            }
        });
    }

    @Override
    public void setMarked(boolean marked) {
        if (marked) {
            this.oldColor = this.getBackground();
            this.setBackground(new Color(255, 0, 0));
        } else {
            this.setBackground(this.oldColor);
        }
    }

    @Override
    public void setHelpText(String text) {
        text = "<html>" + text + "</html>";
        this.getComponent().setToolTipText(text);
    }

    public static void main(String[] args) {
        TimeintervalInput tii = new TimeintervalInput(true);
        tii.setValue("1996-11-01 07:30 2000-10-31 07:30 6 1");
        tii.setEnabled(true);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add(tii.getComponent());
        frame.pack();
        frame.setVisible(true);
    }

    class NumericIntervalVerifier
    extends InputVerifier {
        double lower;
        double upper;

        public NumericIntervalVerifier(double lower, double upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean verify(JComponent input) {
            boolean result = false;
            try {
                double value = Double.parseDouble(((JTextField)input).getText());
                if (value >= this.lower && value <= this.upper) {
                    result = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }
    }
}

