/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.gui.input.JCalendarPopup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class JCalendarButton
extends JButton
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String LANGUAGE_PARAM = "language";
    protected String m_strDateParam = "date";
    protected Date m_dateTarget = null;
    protected String m_strLanguage = null;

    public JCalendarButton() {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            ImageIcon icon = new ImageIcon(cl.getResource("images/buttons/Calendar.gif"));
            this.setIcon(icon);
        }
        catch (Exception ex) {
            this.setText("change");
        }
        this.setMargin(JCalendarPopup.NO_INSETS);
        this.setOpaque(false);
        this.addActionListener(this);
    }

    public JCalendarButton(Date dateTarget) {
        this();
        this.init(null, dateTarget, null);
    }

    public JCalendarButton(String strDateParam, Date dateTarget) {
        this();
        this.init(strDateParam, dateTarget, null);
    }

    public JCalendarButton(String strDateParam, Date dateTarget, String strLanguage) {
        this();
        this.init(strDateParam, dateTarget, strLanguage);
    }

    public void init(String strDateParam, Date dateTarget, String strLanguage) {
        if (strDateParam == null) {
            strDateParam = "date";
        }
        this.m_strDateParam = strDateParam;
        this.m_dateTarget = dateTarget;
        this.m_strLanguage = strLanguage;
    }

    public Date getTargetDate() {
        return this.m_dateTarget;
    }

    public void setTargetDate(Date dateTarget) {
        this.m_dateTarget = dateTarget;
    }

    public String getDateParam() {
        return this.m_strDateParam;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this) {
            Date dateTarget = this.getTargetDate();
            JCalendarPopup popup = JCalendarPopup.createCalendarPopup(this.getDateParam(), dateTarget, this, this.m_strLanguage);
            popup.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        if (this.m_strDateParam.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof Date) {
            this.m_dateTarget = (Date)evt.getNewValue();
        }
        if (LANGUAGE_PARAM.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof String) {
            this.m_strLanguage = (String)evt.getNewValue();
        }
    }
}

