/*
 * Decompiled with CFR 0.152.
 */
package jams.aggregators;

import jams.aggregators.Aggregator;
import java.util.Arrays;

public abstract class DoubleArrayAggregator
extends Aggregator<double[]> {
    double[] v;

    DoubleArrayAggregator(int n) {
        this.v = new double[n];
    }

    public DoubleArrayAggregator(DoubleArrayAggregator copy) {
        this.v = (double[])copy.v.clone();
    }

    public int n() {
        return this.v.length;
    }

    public abstract DoubleArrayAggregator copy();

    @Override
    public void init() {
    }

    @Override
    public double[] get() {
        return this.v;
    }

    @Override
    public void finish() {
    }

    public static DoubleArrayAggregator create(Aggregator.AggregationMode mode, int n) {
        switch (mode) {
            case SUM: {
                return new SumAggregator(n);
            }
            case AVERAGE: {
                return new AverageAggregator(n);
            }
            case LAST: {
                return new LastAggregator(n);
            }
            case MINIMUM: {
                return new MinimumAggregator(n);
            }
            case MAXIMUM: {
                return new MaximumAggregator(n);
            }
            case VARIANCE: {
                return new VarianceAggregator(n);
            }
            case INDEPENDENT: {
                return null;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        DoubleArrayAggregator t = DoubleArrayAggregator.create(Aggregator.AggregationMode.VARIANCE, 2);
        t.init();
        for (int i = 0; i < 20; ++i) {
            t.consider(new double[]{1.0, i * i});
        }
        t.finish();
        System.out.println(Arrays.toString(t.get()));
    }

    static class LastAggregator
    extends DoubleArrayAggregator {
        public LastAggregator(LastAggregator copy) {
            super(copy);
        }

        public LastAggregator(int n) {
            super(n);
        }

        @Override
        public DoubleArrayAggregator copy() {
            return new LastAggregator(this);
        }

        @Override
        public void init() {
            Arrays.fill(this.v, 0.0);
        }

        @Override
        public void consider(double[] x) {
            for (int i = 0; i < this.v.length; ++i) {
                if (Double.isNaN(x[i])) continue;
                this.v[i] = x[i];
            }
        }
    }

    static class FirstAggregator
    extends DoubleArrayAggregator {
        boolean isFirst = true;

        public FirstAggregator(FirstAggregator copy) {
            super(copy);
        }

        public FirstAggregator(int n) {
            super(n);
        }

        @Override
        public DoubleArrayAggregator copy() {
            return new FirstAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, 0.0);
            this.isFirst = true;
        }

        @Override
        public void consider(double[] x) {
            if (this.isFirst) {
                for (int i = 0; i < this.v.length; ++i) {
                    if (Double.isNaN(x[i])) continue;
                    int n = i;
                    this.v[n] = this.v[n] + x[i];
                }
                this.isFirst = false;
            }
        }
    }

    static class VarianceAggregator
    extends DoubleArrayAggregator {
        double[] mean;
        int[] counter;

        public VarianceAggregator(VarianceAggregator copy) {
            super(copy);
            this.mean = Arrays.copyOf(copy.mean, copy.mean.length);
            this.counter = copy.counter;
        }

        public VarianceAggregator(int n) {
            super(n);
            this.mean = new double[n];
            this.counter = new int[n];
        }

        @Override
        public DoubleArrayAggregator copy() {
            return new VarianceAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, 0.0);
            Arrays.fill(this.mean, 0.0);
            Arrays.fill(this.counter, 0);
        }

        @Override
        public void consider(double[] x) {
            for (int i = 0; i < this.n(); ++i) {
                if (Double.isNaN(x[i])) continue;
                int n = i;
                this.counter[n] = this.counter[n] + 1;
                double delta = x[i] - this.mean[i];
                this.mean[i] = this.mean[i] + delta / (double)this.counter[i];
                this.v[i] = this.v[i] + delta * (x[i] - this.mean[i]);
            }
        }

        @Override
        public void finish() {
            super.finish();
            for (int i = 0; i < this.n(); ++i) {
                if (this.counter[i] > 1) {
                    int n = i;
                    this.v[n] = this.v[n] / ((double)this.counter[i] - 1.0);
                } else {
                    this.v[i] = Double.NaN;
                }
                this.counter[i] = 2;
            }
        }
    }

    static class AverageAggregator
    extends DoubleArrayAggregator {
        int[] counter;

        public AverageAggregator(AverageAggregator copy) {
            super(copy);
            this.counter = Arrays.copyOf(copy.counter, copy.counter.length);
        }

        public AverageAggregator(int n) {
            super(n);
            this.counter = new int[n];
        }

        @Override
        public DoubleArrayAggregator copy() {
            return new AverageAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, 0.0);
            Arrays.fill(this.counter, 0);
        }

        @Override
        public void consider(double[] x) {
            for (int i = 0; i < this.v.length; ++i) {
                if (Double.isNaN(x[i])) continue;
                int n = i;
                this.v[n] = this.v[n] + x[i];
                int n2 = i;
                this.counter[n2] = this.counter[n2] + 1;
            }
        }

        @Override
        public void finish() {
            super.finish();
            for (int i = 0; i < this.v.length; ++i) {
                if (this.counter[i] > 0) {
                    int n = i;
                    this.v[n] = this.v[n] / (double)this.counter[i];
                } else {
                    this.v[i] = Double.NaN;
                }
                this.counter[i] = 1;
            }
        }
    }

    static class MaximumAggregator
    extends DoubleArrayAggregator {
        public MaximumAggregator(MaximumAggregator copy) {
            super(copy);
        }

        public MaximumAggregator(int n) {
            super(n);
        }

        @Override
        public DoubleArrayAggregator copy() {
            return new MaximumAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, Double.NEGATIVE_INFINITY);
        }

        @Override
        public void consider(double[] x) {
            for (int i = 0; i < this.v.length; ++i) {
                if (Double.isNaN(x[i])) continue;
                this.v[i] = Math.max(x[i], this.v[i]);
            }
        }
    }

    static class MinimumAggregator
    extends DoubleArrayAggregator {
        public MinimumAggregator(MinimumAggregator copy) {
            super(copy);
        }

        public MinimumAggregator(int n) {
            super(n);
        }

        @Override
        public DoubleArrayAggregator copy() {
            return new MinimumAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, Double.POSITIVE_INFINITY);
        }

        @Override
        public void consider(double[] x) {
            for (int i = 0; i < this.v.length; ++i) {
                if (Double.isNaN(x[i])) continue;
                this.v[i] = Math.min(x[i], this.v[i]);
            }
        }
    }

    static class SumAggregator
    extends DoubleArrayAggregator {
        public SumAggregator(int n) {
            super(n);
        }

        public SumAggregator(SumAggregator copy) {
            super(copy);
        }

        @Override
        public DoubleArrayAggregator copy() {
            return new SumAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, 0.0);
        }

        @Override
        public void consider(double[] x) {
            for (int i = 0; i < this.v.length; ++i) {
                if (Double.isNaN(x[i])) continue;
                int n = i;
                this.v[n] = this.v[n] + x[i];
            }
        }
    }
}

