/*
 * Decompiled with CFR 0.152.
 */
package jams.aggregators;

import jams.aggregators.Aggregator;
import jams.aggregators.TemporalAggregator;
import jams.data.Attribute;
import java.util.Collection;

public class BasicTemporalAggregator<T>
extends TemporalAggregator<T> {
    transient Aggregator<T> aggregator;

    protected BasicTemporalAggregator(BasicTemporalAggregator<T> original) {
        super(original);
        this.aggregator = original.aggregator.copy();
    }

    public BasicTemporalAggregator(Aggregator<T> aggregator, TemporalAggregator.AggregationTimePeriod timePeriod) {
        this(aggregator, timePeriod, null);
    }

    public BasicTemporalAggregator(Aggregator<T> aggregator, TemporalAggregator.AggregationTimePeriod timePeriod, Collection<Attribute.TimeInterval> customTimePeriods) {
        super(timePeriod, customTimePeriods);
        this.aggregator = aggregator;
    }

    @Override
    public void init() {
        this.aggregator.init();
    }

    @Override
    public TemporalAggregator<T> copy() {
        return new BasicTemporalAggregator<T>(this);
    }

    @Override
    public void aggregate(Attribute.Calendar timeStep, T next) {
        if (this.isNextTimeStep(timeStep)) {
            this.aggregator.finish();
            this.consume(this.currentTimeStep(), this.aggregator.get());
            this.aggregator.init();
            this.setTimeStep(timeStep);
        }
        this.aggregator.consider(next);
    }

    @Override
    public void finish() {
        this.aggregator.finish();
        this.consume(this.currentTimeStep(), this.aggregator.get());
        super.finish();
    }
}

