/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.spreadsheet;

import ccindex.explorer.spreadsheet.GraphProperties;
import jams.JAMS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class JAMSXYPlot {
    Vector<GraphProperties> propVector;
    ValueAxis xAxis;
    ValueAxis axisLEFT;
    ValueAxis axisRIGHT;
    int graphCount = 0;
    int graphCountRight = 0;
    int graphCountLeft = 0;
    String xAxisTitle;
    String leftAxisTitle;
    String rightAxisTitle;
    String title;
    ChartPanel chartPanel;
    XYSeriesCollection dataLeft = new XYSeriesCollection();
    XYSeriesCollection dataRight = new XYSeriesCollection();
    XYItemRenderer rightRenderer;
    XYItemRenderer leftRenderer;
    XYPlot plot;
    JFreeChart chart;
    JPanel panel;
    JButton saveButton;
    HashMap<String, Color> colorTable = new HashMap();

    public JAMSXYPlot() {
        this.colorTable.put(JAMS.i18n("YELLOW"), Color.yellow);
        this.colorTable.put(JAMS.i18n("ORANGE"), Color.orange);
        this.colorTable.put(JAMS.i18n("RED"), Color.red);
        this.colorTable.put(JAMS.i18n("PINK"), Color.pink);
        this.colorTable.put(JAMS.i18n("MAGENTA"), Color.magenta);
        this.colorTable.put(JAMS.i18n("CYAN"), Color.cyan);
        this.colorTable.put(JAMS.i18n("BLUE"), Color.blue);
        this.colorTable.put(JAMS.i18n("GREEN"), Color.green);
        this.colorTable.put(JAMS.i18n("GRAY"), Color.gray);
        this.colorTable.put(JAMS.i18n("LIGHTGRAY"), Color.lightGray);
        this.colorTable.put(JAMS.i18n("BLACK"), Color.black);
        this.setDefaultValues();
    }

    public JAMSXYPlot(Vector<GraphProperties> propVector) {
        this.propVector = propVector;
        this.colorTable.put(JAMS.i18n("YELLOW"), Color.yellow);
        this.colorTable.put(JAMS.i18n("ORANGE"), Color.orange);
        this.colorTable.put(JAMS.i18n("RED"), Color.red);
        this.colorTable.put(JAMS.i18n("PINK"), Color.pink);
        this.colorTable.put(JAMS.i18n("MAGENTA"), Color.magenta);
        this.colorTable.put(JAMS.i18n("CYAN"), Color.cyan);
        this.colorTable.put(JAMS.i18n("BLUE"), Color.blue);
        this.colorTable.put(JAMS.i18n("GREEN"), Color.green);
        this.colorTable.put(JAMS.i18n("GRAY"), Color.gray);
        this.colorTable.put(JAMS.i18n("LIGHTGRAY"), Color.lightGray);
        this.colorTable.put(JAMS.i18n("BLACK"), Color.black);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        String xAxisTitle = JAMS.i18n("X_AXIS_TITLE");
        String leftAxisTitle = JAMS.i18n("LEFT_AXIS_TITLE");
        String rightAxisTitle = JAMS.i18n("RIGHT_AXIS_TITLE");
        String title = JAMS.i18n("XYPLOT_ALPHA");
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public BufferedImage getBufferedImage(int w, int h) {
        BufferedImage bi = this.chart.createBufferedImage(w, h);
        return bi;
    }

    public void saveAsEPS(File outfile) {
        try {
            FileOutputStream out = new FileOutputStream(outfile);
            EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
            g2d.setGraphicContext(new GraphicContext());
            int width = 600;
            int height = 400;
            g2d.setupDocument((OutputStream)out, width, height);
            this.chart.draw((Graphics2D)g2d, (Rectangle2D)new Rectangle(width, height));
            g2d.finish();
            out.flush();
            ((OutputStream)out).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private XYItemRenderer getRenderer(int type) {
        XYAreaRenderer r;
        switch (type) {
            case 0: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
                break;
            }
            case 1: {
                XYBarRenderer br = new XYBarRenderer();
                br.setDrawBarOutline(true);
                br.setMargin(0.98);
                r = br;
                break;
            }
            case 2: {
                r = new XYAreaRenderer();
                break;
            }
            case 3: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(true);
                lsr.setShapesFilled(true);
                lsr.setSeriesLinesVisible(0, false);
                r = lsr;
                break;
            }
            case 4: {
                XYDotRenderer dotR = new XYDotRenderer();
                dotR.setDefaultEntityRadius(2);
                dotR.setSeriesShape(0, (Shape)new Rectangle(5, 5));
                dotR.setDotHeight(5);
                dotR.setDotWidth(5);
                r = dotR;
                break;
            }
            case 5: {
                r = new XYStepRenderer();
                break;
            }
            case 6: {
                r = new XYStepAreaRenderer();
                break;
            }
            case 7: {
                r = new XYDifferenceRenderer();
                break;
            }
            default: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
            }
        }
        return r;
    }

    public void createPlot() {
        this.chart = ChartFactory.createXYLineChart((String)JAMS.i18n("CHART_TITLE"), (String)JAMS.i18n("CHART_AXIS_TITLE_DEFAULT1"), (String)JAMS.i18n("CHART_AXIS_TITLE_DEFAULT2"), (XYDataset)this.dataLeft, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.chartPanel.setBackground(Color.WHITE);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.chartPanel, "Center");
        this.plot = this.chart.getXYPlot();
        this.xAxis = this.plot.getDomainAxis();
        this.plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.axisLEFT = this.plot.getRangeAxis();
        this.axisRIGHT = new NumberAxis(this.rightAxisTitle);
    }

    public void setPropVector(Vector<GraphProperties> propVector) {
        this.propVector = propVector;
    }

    public Vector<GraphProperties> getPropVector() {
        return this.propVector;
    }

    public void plotLeft(XYItemRenderer leftRenderer, String nameLeft, String xAxisTitle, boolean inverted) {
        int plot_count = 0;
        int c = this.propVector.size();
        int corr = 0;
        this.dataLeft = new XYSeriesCollection();
        this.axisLEFT.setInverted(inverted);
        this.axisLEFT.setLabel(nameLeft);
        this.xAxis.setLabel(xAxisTitle);
        for (int k = 0; k < c; ++k) {
            if (!this.propVector.get(k).isXSeries()) {
                if (this.propVector.get(k).getPosition() == 0) {
                    ++plot_count;
                    GraphProperties prop = this.propVector.get(k);
                    this.dataLeft.addSeries(prop.getXYS());
                    this.dataRight.removeSeries(prop.getXYS());
                    continue;
                }
                ++corr;
                continue;
            }
            ++corr;
        }
        if (corr == 0) {
            this.dataRight.removeAllSeries();
            this.axisRIGHT.setVisible(false);
            this.axisLEFT.setVisible(true);
            this.plot.setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_LEFT);
            this.plot.setRangeAxis(0, this.axisLEFT);
            this.plot.setDataset(0, (XYDataset)this.dataLeft);
            this.plot.setRenderer(0, leftRenderer);
        }
        if (corr == 1) {
            this.dataRight.removeAllSeries();
            this.axisRIGHT.setVisible(false);
            this.axisLEFT.setVisible(true);
            this.plot.setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_LEFT);
            this.plot.setRangeAxis(0, this.axisLEFT);
            this.plot.setDataset(0, (XYDataset)this.dataLeft);
            this.plot.setRenderer(0, leftRenderer);
        } else {
            this.axisRIGHT.setVisible(true);
            this.plot.setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_LEFT);
            this.plot.setRangeAxis(0, this.axisLEFT);
            this.plot.setDataset(0, (XYDataset)this.dataLeft);
            this.plot.setRenderer(0, leftRenderer);
            this.plot.mapDatasetToRangeAxis(0, 0);
        }
        this.plot.setDomainAxis(0, this.xAxis);
    }

    public void plotEmpty() {
        boolean plot_count = false;
        int c = this.propVector.size();
        boolean corr = false;
        this.dataLeft = new XYSeriesCollection();
        this.axisLEFT.setInverted(false);
        this.axisLEFT.setLabel(JAMS.i18n("LEFT_AXIS_TITLE"));
        this.xAxis.setLabel(this.xAxisTitle);
        this.leftRenderer = this.getRenderer(0);
        this.dataLeft.removeAllSeries();
        this.dataRight.removeAllSeries();
        this.axisRIGHT.setVisible(false);
        this.axisLEFT.setVisible(true);
        this.plot.setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_LEFT);
        this.plot.setRangeAxis(0, this.axisLEFT);
        this.plot.setDataset(0, (XYDataset)this.dataLeft);
        this.plot.setRenderer(0, this.leftRenderer);
        this.plot.setDomainAxis(0, this.xAxis);
        this.plot.mapDatasetToRangeAxis(0, 0);
        this.plot.setDomainAxis(0, this.xAxis);
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void plotRight(XYItemRenderer rightRenderer, String nameRight, String xAxisTitle, boolean inverted) {
        int plot_count = 0;
        int c = this.propVector.size();
        int corr = 0;
        this.dataRight = new XYSeriesCollection();
        this.xAxis.setLabel(xAxisTitle);
        for (int k = 0; k < c; ++k) {
            if (!this.propVector.get(k).isXSeries()) {
                if (this.propVector.get(k).getPosition() == 1) {
                    ++plot_count;
                    GraphProperties prop = this.propVector.get(k);
                    this.dataRight.addSeries(prop.getXYS());
                    this.dataLeft.removeSeries(prop.getXYS());
                    continue;
                }
                ++corr;
                continue;
            }
            ++corr;
        }
        if (corr == 0) {
            this.dataLeft.removeAllSeries();
            this.axisLEFT.setVisible(false);
            this.axisRIGHT.setVisible(true);
            this.axisRIGHT.setInverted(inverted);
            this.axisRIGHT.setLabel(nameRight);
            this.plot.setRangeAxis(1, this.axisRIGHT);
            this.plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            this.plot.setDataset(1, (XYDataset)this.dataRight);
            this.plot.setRenderer(1, rightRenderer);
        }
        if (corr == 1) {
            this.dataLeft.removeAllSeries();
            this.axisLEFT.setVisible(false);
            this.axisRIGHT.setVisible(true);
            this.axisRIGHT.setInverted(inverted);
            this.axisRIGHT.setLabel(nameRight);
            this.plot.setRangeAxis(1, this.axisRIGHT);
            this.plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            this.plot.setDataset(1, (XYDataset)this.dataRight);
            this.plot.setRenderer(1, rightRenderer);
        } else {
            this.axisLEFT.setVisible(true);
            this.axisRIGHT.setInverted(inverted);
            this.axisRIGHT.setLabel(nameRight);
            this.plot.setRangeAxis(1, this.axisRIGHT);
            this.plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            this.plot.setDataset(1, (XYDataset)this.dataRight);
            this.plot.setRenderer(1, rightRenderer);
            this.plot.mapDatasetToRangeAxis(1, 1);
        }
        this.plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        this.plot.setDomainAxis(0, this.xAxis);
    }
}

