/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.spreadsheet;

import ccindex.explorer.JAMSExplorer;
import ccindex.explorer.gui.StatisticDialogPanel;
import ccindex.explorer.spreadsheet.JAMSTableModel;
import ccindex.explorer.spreadsheet.JTSConfigurator;
import ccindex.explorer.spreadsheet.JXYConfigurator;
import ccindex.explorer.spreadsheet.STPConfigurator;
import ccindex.explorer.spreadsheet.SpreadsheetConstants;
import ccindex.explorer.spreadsheet.TimeIntervalInputDialog;
import ccindex.explorer.tools.ShapeFileWriter;
import jams.JAMS;
import jams.JAMSFileFilter;
import jams.JAMSLogging;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.data.JAMSCalendar;
import jams.gui.tools.GUIHelper;
import jams.math.statistics.MannKendall;
import jams.tools.StringTools;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.datatypes.DoubleValue;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.stores.ShapeFileDataStore;
import jams.workspace.stores.TSDataStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JAMSSpreadSheet
extends JPanel {
    File ttpFile;
    File dtpFile;
    private final String title = "";
    private JPanel panel = new JPanel();
    private String panelname = "spreadsheet";
    private JFrame parent_frame;
    private boolean timeRuns = false;
    GridBagLayout panellayout = new GridBagLayout();
    GridBagConstraints grid = new GridBagConstraints();
    private JScrollPane scrollpane = new JScrollPane();
    private boolean output_sheet = false;
    private String name = JAMS.i18n("DEFAULT");
    private JButton savebutton = new JButton(JAMS.i18n("SAVE_DATA"));
    private JButton statButton = new JButton(JAMS.i18n("STATISTIK"));
    private JButton plotButton = new JButton(JAMS.i18n("TIME_PLOT"));
    private JButton trendButton = new JButton(JAMS.i18n("Trend_Estimation"));
    private JButton dataplotButton = new JButton(JAMS.i18n("DATA_PLOT"));
    private JButton closeButton = new JButton(JAMS.i18n("CLOSE_TAB"));
    private JCheckBox useTemplateButton = new JCheckBox(JAMS.i18n("USE_TEMPLATE"));
    private JCheckBox useTransposedButton = new JCheckBox(JAMS.i18n("USE_TRANSPOSED"));
    private JButton stpButton = new JButton(JAMS.i18n("STACKED_TIME_PLOT"));
    private JComboBox shapeSelector = new JComboBox();
    private JLabel headerlabel = new JLabel();
    private JLabel titleLabel = new JLabel("");
    private JLabel calclabel = new JLabel(JAMS.i18n("CALCLABEL"));
    private JAMSTableModel tmodel;
    private JTableHeader tableHeader;
    private TSDataStore store;
    private File outputDSDir;
    JTable table;
    private String[] calclist = new String[]{JAMS.i18n("SUM____"), JAMS.i18n("MEAN___")};
    JComboBox calculations = new JComboBox<String>(this.calclist);
    private int kindofcalc = 0;
    private JFileChooser epsFileChooser;
    private JFileChooser templateChooser;
    private JFileChooser datChooser;
    private JFileChooser savefileChooser;
    private JAMSExplorer explorer;
    final String ERR_MSG_CTS = JAMS.i18n("NO_DATA_LOADED");
    public static final DataFlavor FLAVOR = DataFlavor.stringFlavor;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };
    ActionListener saveAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JAMSSpreadSheet.this.saveSpreadsheet();
            }
            catch (Throwable ex) {
                Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };
    ActionListener loadAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JAMSSpreadSheet.this.loadSpreadsheet();
            }
            catch (Throwable fnfexc) {
                Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.SEVERE, null, fnfexc);
            }
        }
    };
    ActionListener statisticAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JAMSSpreadSheet.this.showStatisticsPanel();
            }
            catch (Throwable fnfexc) {
                Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.SEVERE, null, fnfexc);
            }
        }
    };
    ActionListener closeTabAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAMSSpreadSheet.this.close();
        }
    };
    ActionListener plotAction = new ActionListener(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (JAMSSpreadSheet.this.useTemplateButton.isSelected()) {
                if (JAMSSpreadSheet.this.isOutputSheet()) {
                    String fileID = JAMSSpreadSheet.this.getID();
                    StringTokenizer name_tokenizer = new StringTokenizer(fileID, ".");
                    String filename = "";
                    filename = name_tokenizer.hasMoreTokens() ? name_tokenizer.nextToken() + ".ttp" : fileID + ".ttp";
                    JAMSSpreadSheet.this.ttpFile = new File(JAMSSpreadSheet.this.getOutputDSDir(), filename);
                } else {
                    JAMSSpreadSheet.this.ttpFile = new File(JAMSSpreadSheet.this.explorer.getWorkspace().getDirectory().toString() + "/explorer", JAMSSpreadSheet.this.store.getID() + ".ttp");
                }
                if (JAMSSpreadSheet.this.ttpFile == null) return;
                if (JAMSSpreadSheet.this.ttpFile.exists()) {
                    try {
                        JAMSSpreadSheet.this.openCTS(JAMSSpreadSheet.this.ttpFile);
                        return;
                    }
                    catch (Exception ee) {
                        Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.SEVERE, null, ee);
                        try {
                            int returnVal;
                            JFileChooser chooser = JAMSSpreadSheet.this.getTemplateChooser();
                            if (JAMSSpreadSheet.this.isOutputSheet()) {
                                chooser.setCurrentDirectory(JAMSSpreadSheet.this.outputDSDir);
                            }
                            if ((returnVal = chooser.showOpenDialog(JAMSSpreadSheet.this.parent_frame)) != 0) return;
                            JAMSSpreadSheet.this.ttpFile = chooser.getSelectedFile();
                            JAMSSpreadSheet.this.openCTS(JAMSSpreadSheet.this.ttpFile);
                            return;
                        }
                        catch (Exception fnfex) {
                            if (!JAMSSpreadSheet.this.timeRuns) return;
                        }
                    }
                    return;
                } else {
                    try {
                        int returnVal;
                        JFileChooser chooser = JAMSSpreadSheet.this.getTemplateChooser();
                        if (JAMSSpreadSheet.this.isOutputSheet()) {
                            chooser.setCurrentDirectory(JAMSSpreadSheet.this.outputDSDir);
                        }
                        if ((returnVal = chooser.showOpenDialog(JAMSSpreadSheet.this.parent_frame)) == 0) {
                            JAMSSpreadSheet.this.ttpFile = chooser.getSelectedFile();
                        }
                        JAMSSpreadSheet.this.openCTS(JAMSSpreadSheet.this.ttpFile);
                        return;
                    }
                    catch (Exception fnfex) {
                        if (!JAMSSpreadSheet.this.timeRuns) return;
                        JAMSSpreadSheet.this.table.setColumnSelectionInterval(1, JAMSSpreadSheet.this.table.getColumnCount() - 1);
                        JAMSSpreadSheet.this.openCTS();
                    }
                }
                return;
            } else {
                JAMSSpreadSheet.this.openCTS();
            }
        }
    };
    ActionListener dataplotAction = new ActionListener(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (JAMSSpreadSheet.this.useTemplateButton.isSelected()) {
                if (JAMSSpreadSheet.this.isOutputSheet()) {
                    String fileID = JAMSSpreadSheet.this.getID();
                    StringTokenizer name_tokenizer = new StringTokenizer(fileID, ".");
                    String filename = "";
                    filename = name_tokenizer.hasMoreTokens() ? name_tokenizer.nextToken() + ".ttp" : fileID + ".ttp";
                    JAMSSpreadSheet.this.ttpFile = new File(JAMSSpreadSheet.this.getOutputDSDir(), filename);
                } else {
                    JAMSSpreadSheet.this.ttpFile = new File(JAMSSpreadSheet.this.explorer.getWorkspace().getDirectory().toString() + "/explorer", JAMSSpreadSheet.this.store.getID() + ".ttp");
                }
                if (JAMSSpreadSheet.this.ttpFile == null) return;
                if (JAMSSpreadSheet.this.ttpFile.exists()) {
                    try {
                        JAMSSpreadSheet.this.openCXYS(JAMSSpreadSheet.this.ttpFile);
                        return;
                    }
                    catch (Exception ee) {
                        Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.SEVERE, null, ee);
                        try {
                            int returnVal;
                            JFileChooser chooser = JAMSSpreadSheet.this.getTemplateChooser();
                            if (JAMSSpreadSheet.this.isOutputSheet()) {
                                chooser.setCurrentDirectory(JAMSSpreadSheet.this.outputDSDir);
                            }
                            if ((returnVal = chooser.showOpenDialog(JAMSSpreadSheet.this.parent_frame)) != 0) return;
                            JAMSSpreadSheet.this.ttpFile = chooser.getSelectedFile();
                            JAMSSpreadSheet.this.openCXYS(JAMSSpreadSheet.this.ttpFile);
                            return;
                        }
                        catch (Exception fnfex) {
                            if (!JAMSSpreadSheet.this.timeRuns) return;
                        }
                    }
                    return;
                } else {
                    try {
                        JFileChooser chooser = JAMSSpreadSheet.this.getTemplateChooser();
                        int returnVal = chooser.showOpenDialog(JAMSSpreadSheet.this.parent_frame);
                        if (returnVal == 0) {
                            JAMSSpreadSheet.this.ttpFile = chooser.getSelectedFile();
                        }
                        JAMSSpreadSheet.this.openCXYS(JAMSSpreadSheet.this.ttpFile);
                        return;
                    }
                    catch (Exception fnfex) {
                        if (!JAMSSpreadSheet.this.timeRuns) return;
                        JAMSSpreadSheet.this.table.setColumnSelectionInterval(1, JAMSSpreadSheet.this.table.getColumnCount() - 1);
                        JAMSSpreadSheet.this.openCXYS();
                    }
                }
                return;
            } else {
                JAMSSpreadSheet.this.openCXYS();
            }
        }
    };
    ActionListener stpAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JAMSSpreadSheet.this.openSTP();
            }
            catch (ClassCastException cce) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, cce.toString(), cce);
            }
        }
    };
    Action joinMapAction = new AbstractAction(JAMS.i18n("WRITE_TO_SHAPE")){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JAMSSpreadSheet.this.writeToShapeFileAction();
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, t.toString(), t);
            }
        }
    };
    Action trendAction = new AbstractAction(JAMS.i18n("Trend_Estimation")){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JAMSSpreadSheet.this.estimateTrends();
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, t.toString(), t);
            }
        }
    };

    public JAMSSpreadSheet(JAMSExplorer explorer) {
        this.explorer = explorer;
        this.parent_frame = explorer.getExplorerFrame();
        JAMSLogging.registerLogger(JAMSLogging.LogOption.Show, Logger.getLogger(JAMSSpreadSheet.class.getName()));
    }

    private void close() {
        this.explorer.getDisplayManager().removeDisplay(this.name);
    }

    public String getID() {
        return this.name;
    }

    public void setID(String name) {
        this.name = name;
    }

    public TSDataStore getStore() {
        return this.store;
    }

    public void init() {
        this.tmodel = new JAMSTableModel();
        this.createPanel();
        this.updateGUI();
    }

    public JFileChooser getTemplateChooser() {
        File explorerDir = !this.isOutputSheet() ? new File(this.explorer.getWorkspace().getDirectory().toString() + "/explorer") : new File(this.explorer.getWorkspace().getDirectory().toString() + "/output/current");
        if (this.templateChooser == null) {
            this.templateChooser = new JFileChooser();
            this.templateChooser.setFileFilter(JAMSFileFilter.getTtpFilter());
            explorerDir = new File(this.explorer.getWorkspace().getDirectory().toString() + "/explorer");
            this.templateChooser.setCurrentDirectory(explorerDir);
        }
        this.templateChooser.setCurrentDirectory(explorerDir);
        this.templateChooser.setFileFilter(JAMSFileFilter.getTtpFilter());
        this.templateChooser.setSelectedFile(new File(""));
        return this.templateChooser;
    }

    private String[] getSaveHeaders() {
        int[] selectedColumns;
        int[] writeColumns = selectedColumns = this.table.getSelectedColumns();
        String[] write_headers = new String[writeColumns.length];
        for (int i = 0; i < writeColumns.length; ++i) {
            write_headers[i] = this.table.getColumnName(writeColumns[i]);
        }
        String[] headers_with_time = new String[write_headers.length + 1];
        headers_with_time[0] = JAMS.i18n("ID");
        System.arraycopy(write_headers, 0, headers_with_time, 1, write_headers.length);
        return write_headers;
    }

    public void loadSpreadsheet() {
        int returnVal = this.getDatChooser().showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.getDatChooser().getSelectedFile();
            this.load(file);
        }
    }

    public void saveSpreadsheet() throws IOException {
        JFileChooser saveDlg = new JFileChooser();
        saveDlg.setFileFilter(JAMSFileFilter.getSdatFilter());
        saveDlg.setFileSelectionMode(0);
        saveDlg.setCurrentDirectory(this.explorer.getWorkspace().getDirectory());
        int rc = saveDlg.showSaveDialog(this.panel);
        if (rc != 0) {
            return;
        }
        String filename = saveDlg.getSelectedFile().getName();
        this.setOutputDSDir(saveDlg.getCurrentDirectory());
        if (filename != null) {
            if (!filename.contains(".") && saveDlg.getFileFilter() == JAMSFileFilter.getSdatFilter()) {
                filename = filename + ".sdat";
            }
            if (this.isOutputSheet()) {
                String fileexists;
                int result;
                File file = new File(this.getOutputDSDir(), filename);
                if (file.exists() && (result = GUIHelper.showYesNoDlg(this.parent_frame, fileexists = JAMS.i18n("THE_FILE_") + file + JAMS.i18n("_ALREADY_EXISTS._OVERWRITE?"), JAMS.i18n("FILE_ALREADY_EXISTS"))) != 0) {
                    return;
                }
                this.save(filename, this.getSaveHeaders());
            } else {
                String fileexists;
                int result;
                File file = new File(this.explorer.getWorkspace().getDirectory().toString() + "/explorer", filename);
                if (file.exists() && (result = GUIHelper.showYesNoDlg(this.parent_frame, fileexists = JAMS.i18n("THE_FILE_") + file + JAMS.i18n("_ALREADY_EXISTS._OVERWRITE?"), JAMS.i18n("FILE_ALREADY_EXISTS"))) != 0) {
                    return;
                }
                this.save(filename, this.getSaveHeaders());
            }
        }
    }

    public void saveAll(String filename) {
        int colcount = this.tmodel.getColumnCount();
        int rowcount = this.tmodel.getRowCount();
        String[] columnNames = this.tmodel.getCoulumnNameArray();
        try {
            File file = this.isOutputSheet() ? new File(this.getOutputDSDir().toString() + "/" + filename) : new File(this.explorer.getWorkspace().getDirectory().toString() + "/explorer" + filename);
            FileWriter filewriter = new FileWriter(file);
            filewriter.write("#headers\r\n");
            String col_string = "";
            for (int j = 0; j < colcount; ++j) {
                col_string = columnNames[j];
                if (j == colcount - 1) {
                    filewriter.write(columnNames[j], 0, columnNames[j].length());
                    continue;
                }
                filewriter.write(columnNames[j], 0, columnNames[j].length());
                filewriter.write("\t");
            }
            filewriter.write("\r\n#data");
            filewriter.write("\r\n");
            for (int k = 0; k < rowcount; ++k) {
                for (int i = 0; i < colcount; ++i) {
                    String value;
                    if (i == colcount - 1) {
                        value = this.table.getValueAt(k, i).toString();
                        filewriter.write(value, 0, value.length());
                        continue;
                    }
                    value = this.table.getValueAt(k, i).toString();
                    filewriter.write(value, 0, value.length());
                    filewriter.write("\t");
                }
                filewriter.write("\r\n");
            }
            filewriter.write("#end");
            filewriter.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void load(File file) {
        Vector<double[]> arrayVector = new Vector<double[]>();
        Vector<Attribute.Calendar> timeVector = new Vector<Attribute.Calendar>();
        StringTokenizer st = new StringTokenizer("\t");
        this.outputDSDir = file.getParentFile();
        ArrayList<String> headerList = new ArrayList<String>();
        boolean b_headers = false;
        boolean b_data = false;
        boolean time_set = false;
        boolean stop = false;
        int file_columns = 0;
        String ST_DATA = "#data";
        String ST_HEADERS = "#headers";
        String ST_END = "#end";
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            while (in.ready()) {
                String s = in.readLine();
                st = new StringTokenizer(s, "\t");
                String actual_string = "";
                boolean breakpoint = false;
                if (b_data) {
                    int i = 0;
                    Attribute.Calendar timeval = DefaultDataFactory.getDataFactory().createCalendar();
                    double[] rowBuffer = new double[file_columns - 1];
                    while (st.hasMoreTokens()) {
                        actual_string = st.nextToken();
                        if (actual_string.compareTo("#end") != 0) {
                            if (!time_set) {
                                try {
                                    timeval.setValue(actual_string, "yyyy-MM-dd hh:mm");
                                }
                                catch (ParseException pe) {
                                    GUIHelper.showErrorDlg(this, SpreadsheetConstants.SPREADSHEET_ERR_TSMISSING, JAMS.i18n("ERROR"));
                                    breakpoint = true;
                                    break;
                                }
                                timeVector.add(timeval);
                                time_set = true;
                                continue;
                            }
                            try {
                                Double val = new Double(actual_string);
                                rowBuffer[i++] = val;
                            }
                            catch (Exception pe2) {
                                Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.SEVERE, null, pe2);
                            }
                            continue;
                        }
                        stop = true;
                    }
                    if (breakpoint) break;
                    if (stop) continue;
                    arrayVector.add(rowBuffer);
                    time_set = false;
                    continue;
                }
                while (st.hasMoreTokens()) {
                    String test = st.nextToken();
                    if (test.compareTo("#data") == 0) {
                        b_data = true;
                        b_headers = false;
                        file_columns = headerList.size();
                    }
                    if (b_headers) {
                        headerList.add(test);
                    }
                    if (test.compareTo("#headers") != 0) continue;
                    b_headers = true;
                }
            }
            in.close();
            String[] headers = new String[file_columns];
            headers = headerList.toArray(headers);
            this.tmodel = new JAMSTableModel();
            this.tmodel.setTimeRuns(true);
            this.timeRuns = true;
            this.tmodel.setTimeVector(timeVector);
            this.tmodel.setNewDataVector(arrayVector);
            this.tmodel.setColumnNames(headers);
            this.updateGUI();
        }
        catch (Exception eee) {
            GUIHelper.showErrorDlg(this, JAMS.i18n("FILE_NOT_FOUND!"), JAMS.i18n("ERROR!"));
        }
    }

    public void save(String filename, String[] write_headers) throws IOException {
        int colcount = this.tmodel.getColumnCount();
        int rowcount = this.tmodel.getRowCount();
        int write_col_cnt = write_headers.length;
        int[] col_index = new int[write_col_cnt];
        String[] columnNames = this.tmodel.getCoulumnNameArray();
        File file = this.isOutputSheet() ? new File(this.getOutputDSDir().toString() + "/" + filename) : new File(this.getOutputDSDir().toString() + "/explorer" + filename);
        FileWriter filewriter = new FileWriter(file);
        if (!this.useTransposedButton.isSelected()) {
            filewriter.write("#headers\r\n");
            String col_string = "";
            for (int j = 0; j < colcount; ++j) {
                col_string = columnNames[j];
                for (int c = 0; c < write_col_cnt; ++c) {
                    if (col_string.compareTo(write_headers[c]) != 0) continue;
                    if (c == write_col_cnt - 1) {
                        filewriter.write(columnNames[j], 0, columnNames[j].length());
                        col_index[c] = j;
                        continue;
                    }
                    filewriter.write(columnNames[j], 0, columnNames[j].length());
                    filewriter.write("\t");
                    col_index[c] = j;
                }
            }
            filewriter.write("\r\n#data");
            filewriter.write("\r\n");
            for (int k = 0; k < rowcount; ++k) {
                for (int i = 0; i < write_col_cnt; ++i) {
                    String value = this.table.getValueAt(k, col_index[i]).toString();
                    filewriter.write(value, 0, value.length());
                    if (i >= write_col_cnt - 1) continue;
                    filewriter.write("\t");
                }
                filewriter.write("\r\n");
            }
            filewriter.write("#end");
            filewriter.close();
        } else {
            TreeMap<String, Integer> map = new TreeMap<String, Integer>();
            for (int j = 0; j < colcount; ++j) {
                String col_string = columnNames[j];
                map.put(col_string, j);
            }
            for (int c = 0; c < write_col_cnt; ++c) {
                Integer i = (Integer)map.get(write_headers[c]);
                col_index[c] = i;
            }
            filewriter.write("#data\n");
            for (int i = 0; i < write_col_cnt; ++i) {
                filewriter.write(columnNames[col_index[i]] + "\t");
                for (int k = 0; k < rowcount; ++k) {
                    filewriter.write(this.table.getValueAt(k, col_index[i]).toString());
                    filewriter.write("\t");
                }
                filewriter.write("\n");
            }
            filewriter.write("#end");
            filewriter.close();
        }
    }

    public void showStatisticsPanel() {
        String[] headers = this.getSelectedColumnNames();
        double[][] data = this.getSelectedData();
        StatisticDialogPanel statPanel = new StatisticDialogPanel((Frame)this.parent_frame, true, headers, data);
        statPanel.setVisible(true);
        statPanel.getReturnStatus();
    }

    public void estimateTrends() {
        Attribute.Calendar endDate;
        Attribute.Calendar startDate;
        if (!this.timeRuns()) {
            throw new ProcessingException(JAMS.i18n("Need temporal data"));
        }
        String[] dateColumn = this.getValueOfColumn(0);
        String[] ids = this.getColumnNames();
        int T = dateColumn.length;
        try {
            startDate = DefaultDataFactory.getDataFactory().createCalendar();
            startDate.setTime(this.sdf.parse(dateColumn[0]));
            endDate = DefaultDataFactory.getDataFactory().createCalendar();
            endDate.setTime(this.sdf.parse(dateColumn[dateColumn.length - 1]));
        }
        catch (ParseException pe) {
            throw new ProcessingException(JAMS.i18n("Unable to parse first or last date!"), pe);
        }
        Attribute.TimeInterval tii = DefaultDataFactory.getDataFactory().createTimeInterval();
        tii.setStart(startDate);
        tii.setEnd(endDate);
        boolean[] selectedIndices = new boolean[T];
        Date[] dates = new Date[T];
        int selectionCount = 0;
        for (int i = 0; i < T; ++i) {
            selectedIndices[i] = false;
            try {
                Date date = this.sdf.parse(dateColumn[i]);
                if (date.getTime() >= startDate.getTimeInMillis() && date.getTime() <= endDate.getTimeInMillis()) {
                    selectedIndices[i] = true;
                    ++selectionCount;
                }
                dates[i] = date;
                continue;
            }
            catch (ParseException pe) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, JAMS.i18n("Unable to parse date " + dateColumn[i]), pe);
            }
        }
        if ((tii = TimeIntervalInputDialog.showTimeIntervalInputDialog("Select trend estimation time interval", tii)) == null) {
            return;
        }
        int K = this.getColumnCount();
        double[] x = new double[selectionCount];
        double[] y = new double[selectionCount];
        double[][] result = new double[K - 1][2];
        for (int i = 1; i < K; ++i) {
            String[] data = this.getValueOfColumn(i);
            int c = 0;
            for (int j = 0; j < T; ++j) {
                if (!selectedIndices[j]) continue;
                x[c] = dates[j].getTime() / 1000L;
                try {
                    y[c] = Double.parseDouble(data[j]);
                }
                catch (NumberFormatException nfe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, JAMS.i18n("Unable to parse value " + data[j]), nfe);
                }
                ++c;
            }
            double[] mk = MannKendall.MannKendall(x, y);
            result[i - 1][0] = mk[0];
            result[i - 1][1] = mk[1];
        }
        Object[] id2 = new String[ids.length - 1];
        for (int i = 1; i < ids.length; ++i) {
            id2[i - 1] = ids[i];
        }
        DataMatrix m = new DataMatrix(result, id2, new String[]{"tau", "p"});
        this.loadMatrix(m, this.outputDSDir, false);
    }

    public JFileChooser getDatChooser() {
        if (this.datChooser == null) {
            this.datChooser = new JFileChooser();
            this.datChooser.setFileFilter(JAMSFileFilter.getDatFilter());
            File explorerDir = new File(this.explorer.getWorkspace().getDirectory().toString() + "/explorer");
            this.datChooser.setCurrentDirectory(explorerDir);
        }
        this.datChooser.setFileFilter(JAMSFileFilter.getDatFilter());
        this.datChooser.setSelectedFile(new File(""));
        return this.datChooser;
    }

    public JFileChooser getEPSFileChooser() {
        if (this.epsFileChooser == null) {
            this.epsFileChooser = new JFileChooser();
            this.epsFileChooser.setFileFilter(JAMSFileFilter.getEpsFilter());
        }
        this.epsFileChooser.setSelectedFile(new File(""));
        return this.epsFileChooser;
    }

    public File getOutputDSDir() {
        return this.outputDSDir;
    }

    public void setOutputDSDir(File outputDSDir) {
        this.outputDSDir = outputDSDir;
    }

    public JComboBox getShapeSelector() {
        return this.shapeSelector;
    }

    private void formatDoubleArray(double[] rowBuffer) {
        int digits = Integer.parseInt(this.explorer.getProperties().getProperty("explorerdigits", "8"));
        long factor = (long)Math.pow(10.0, digits);
        for (int i = 0; i < rowBuffer.length; ++i) {
            if (Double.isNaN(rowBuffer[i]) || Double.isInfinite(rowBuffer[i])) continue;
            double testValue = (double)factor * rowBuffer[i];
            rowBuffer[i] = testValue - Math.floor(testValue) < 0.5 ? Math.floor(testValue) / (double)factor : Math.ceil(testValue) / (double)factor;
        }
    }

    public void loadMatrix(DataMatrix m, File outputDSDir, boolean timeSeries) {
        Vector<double[]> arrayVector = new Vector<double[]>();
        Vector<Attribute.Calendar> timeVector = new Vector<Attribute.Calendar>();
        this.outputDSDir = outputDSDir;
        int pos = 0;
        Object[] ids = m.getIds();
        this.tmodel = new JAMSTableModel();
        if (timeSeries) {
            this.timeRuns = true;
            this.tmodel.setTimeRuns(this.timeRuns);
        }
        for (Object id : ids) {
            double[] rowBuffer;
            if (timeSeries) {
                Attribute.Calendar timeval = DefaultDataFactory.getDataFactory().createCalendar();
                timeval.setValue(id.toString());
                timeVector.add(timeval);
                rowBuffer = m.getRow(pos);
            } else {
                rowBuffer = new double[m.getColumnDimension() + 1];
                try {
                    rowBuffer[0] = Double.parseDouble(id.toString());
                }
                catch (Exception e) {
                    rowBuffer[0] = 0.0;
                }
                double[] source = m.getRow(pos);
                System.arraycopy(source, 0, rowBuffer, 1, source.length);
            }
            this.formatDoubleArray(rowBuffer);
            arrayVector.add(rowBuffer);
            ++pos;
        }
        if (timeSeries) {
            this.tmodel.setTimeVector(timeVector);
        }
        String[] attribtuteIDs = m.getAttributeIDs();
        String[] headers = new String[attribtuteIDs.length + 1];
        headers[0] = JAMS.i18n("ID");
        for (int i = 1; i < headers.length; ++i) {
            headers[i] = attribtuteIDs[i - 1];
        }
        this.tmodel.setNewDataVector(arrayVector);
        this.tmodel.setColumnNames(headers);
        this.updateGUI();
    }

    public void loadTSDS(TSDataStore store, File inputDSDir) throws Exception {
        this.store = store;
        String dumpTimeFormat = store.getTimeFormat();
        int colNumber = 0;
        File explorerDir = new File(this.explorer.getWorkspace().getDirectory().toString() + "/explorer");
        this.getTemplateChooser().setCurrentDirectory(explorerDir);
        this.getEPSFileChooser().setCurrentDirectory(inputDSDir.getParentFile());
        this.ttpFile = new File(this.explorer.getWorkspace().getDirectory().toString() + "/explorer", store.getID() + ".ttp");
        Vector<double[]> arrayVector = new Vector<double[]>();
        Vector<Attribute.Calendar> timeVector = new Vector<Attribute.Calendar>();
        ArrayList<Object> names = store.getDataSetDefinition().getAttributeValues("NAME");
        colNumber = store.getDataSetDefinition().getColumnCount();
        String[] headers = new String[colNumber + 1];
        headers[0] = "";
        int i = 1;
        for (Object o : names) {
            headers[i++] = (String)o;
        }
        DefaultDataSet ds = null;
        while (store.hasNext()) {
            try {
                ds = store.getNext();
            }
            catch (Exception e) {
                e.printStackTrace();
                GUIHelper.showErrorDlg(this, JAMS.i18n("Trying_to_read_past_end_of_datastore"), JAMS.i18n("ERROR"));
                return;
            }
            DataValue[] rowData = ds.getData();
            if (rowData == null) break;
            Attribute.Calendar timeval = DefaultDataFactory.getDataFactory().createCalendar();
            try {
                String timeString = rowData[0].getString();
                timeval.setValue(timeString);
                timeval.setDateFormat(dumpTimeFormat);
            }
            catch (Exception pe) {
                Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.SEVERE, null, pe);
            }
            timeVector.add(timeval);
            double[] rowBuffer = new double[colNumber];
            for (i = 1; i < rowData.length; ++i) {
                rowBuffer[i - 1] = rowData[i] instanceof DoubleValue && rowData[i].getDouble() != JAMS.getMissingDataValue() ? ((DoubleValue)rowData[i]).getDouble() : Double.NaN;
            }
            this.formatDoubleArray(rowBuffer);
            arrayVector.add(rowBuffer);
        }
        store.close();
        this.tmodel = new JAMSTableModel();
        this.tmodel.setTimeRuns(true);
        this.timeRuns = true;
        this.tmodel.setTimeVector(timeVector);
        this.tmodel.setNewDataVector(arrayVector);
        this.tmodel.setColumnNames(headers);
        this.updateGUI();
    }

    public void setAsOutputSheet() {
        this.output_sheet = true;
    }

    public boolean isOutputSheet() {
        return this.output_sheet;
    }

    private void openCTS() {
        try {
            if (this.table.getValueAt(0, 0).getClass().equals(JAMSCalendar.class)) {
                JTSConfigurator jTSConfigurator = new JTSConfigurator(this.explorer.getExplorerFrame(), this, this.explorer);
            } else {
                GUIHelper.showErrorDlg(this, this.ERR_MSG_CTS, JAMS.i18n("ERROR"));
            }
        }
        catch (IndexOutOfBoundsException ex) {
            GUIHelper.showErrorDlg(this, this.ERR_MSG_CTS, JAMS.i18n("ERROR"));
        }
    }

    private void openCTS(File templateFile) {
        if (this.table.getValueAt(0, 0).getClass().equals(JAMSCalendar.class)) {
            if (this.useTemplateButton.isSelected()) {
                JTSConfigurator jts = new JTSConfigurator(this.explorer.getExplorerFrame(), this, templateFile, this.explorer);
            } else {
                JTSConfigurator jTSConfigurator = new JTSConfigurator(this.explorer.getExplorerFrame(), this, null, this.explorer);
            }
        } else {
            GUIHelper.showErrorDlg(this, this.ERR_MSG_CTS, JAMS.i18n("ERROR"));
        }
    }

    private void openCXYS() {
        try {
            JXYConfigurator jxys = new JXYConfigurator(this.explorer.getExplorerFrame(), this, null, this.explorer);
        }
        catch (NullPointerException npe) {
            JXYConfigurator jxys = new JXYConfigurator(this.explorer.getExplorerFrame(), this, null, this.explorer);
        }
        catch (IndexOutOfBoundsException ex) {
            GUIHelper.showErrorDlg(this, this.ERR_MSG_CTS, JAMS.i18n("ERROR"));
        }
    }

    private void openCXYS(File templateFile) {
        if (this.useTemplateButton.isSelected()) {
            JXYConfigurator jxys = new JXYConfigurator(this.explorer.getExplorerFrame(), this, templateFile, this.explorer);
        } else {
            JXYConfigurator jxys = new JXYConfigurator(this.explorer.getExplorerFrame(), this, null, this.explorer);
        }
    }

    private void openSTP() {
        STPConfigurator stp = new STPConfigurator(this.explorer, this);
    }

    private void writeToShapeFileAction() {
        String selectedShape = (String)this.shapeSelector.getSelectedItem();
        if (StringTools.isEmptyString(selectedShape)) {
            GUIHelper.showErrorDlg(this.explorer.getExplorerFrame(), "No Shapefile selected.");
            return;
        }
        ShapeFileDataStore dataStore = (ShapeFileDataStore)this.explorer.getWorkspace().getInputDataStore(selectedShape);
        if (dataStore == null) {
            GUIHelper.showErrorDlg(this.explorer.getExplorerFrame(), "No datastore found.");
            return;
        }
        URI inUri = dataStore.getUri();
        if (inUri == null) {
            GUIHelper.showErrorDlg(this.explorer.getExplorerFrame(), "Can't access Shapefile! path is: \"" + dataStore.getShapeFile().getAbsolutePath() + "\"");
            return;
        }
        int[] columns = this.table.getSelectedColumns();
        if (columns.length == 0) {
            GUIHelper.showErrorDlg(this.explorer.getExplorerFrame(), "No columns selected.");
            return;
        }
        String keyColumn = dataStore.getKeyColumn();
        File outFile = new File(this.explorer.getWorkspace().getOutputDataDirectory(), new File(inUri).toPath().getFileName().toString());
        JFileChooser jfc = GUIHelper.getJFileChooser(JAMSFileFilter.getShapeFilter());
        jfc.setSelectedFile(outFile);
        int result = jfc.showOpenDialog(this.panel);
        if (result == 1) {
            return;
        }
        outFile = jfc.getSelectedFile();
        URI outUri = outFile.toURI();
        String[] headers = this.getSelectedColumnNames();
        double[][] data = this.getSelectedData();
        double[] ids = this.getIdValues();
        ShapeFileWriter writer = new ShapeFileWriter();
        writer.setNames(headers);
        writer.setIds(ids);
        writer.setData(data);
        writer.setInShapefileURI(inUri);
        writer.setTargetKeyName(keyColumn);
        writer.setOutShapefileURI(outUri);
        try {
            writer.writeShape();
        }
        catch (IOException ex) {
            Logger.getLogger(JAMSSpreadSheet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean timeRuns() {
        return this.timeRuns;
    }

    private double[] getIdValues() {
        int rowCount = this.table.getRowCount();
        double[] ids = new double[rowCount];
        for (int j = 0; j < rowCount; ++j) {
            ids[j] = (Double)this.table.getValueAt(j, 0);
        }
        return ids;
    }

    private String[] getValueOfColumn(int col) {
        int rowCount = this.table.getRowCount();
        String[] data = new String[rowCount];
        for (int j = 0; j < rowCount; ++j) {
            data[j] = this.table.getValueAt(j, col).toString();
        }
        return data;
    }

    private String getCellValue(int row, int col) {
        return this.table.getValueAt(row, col).toString();
    }

    private int getColumnCount() {
        return this.table.getColumnCount();
    }

    private int getRowCount() {
        return this.table.getRowCount();
    }

    private double[][] getSelectedData() {
        int[] columns = this.table.getSelectedColumns();
        if (columns.length == 0) {
            return null;
        }
        int rowCount = this.table.getRowCount();
        double[][] data = new double[columns.length][rowCount];
        for (int i = 0; i < columns.length; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                data[i][j] = (Double)this.table.getValueAt(j, columns[i]);
            }
        }
        return data;
    }

    private String[] getColumnNames() {
        String[] headers = new String[this.table.getColumnCount()];
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            headers[i] = this.table.getColumnName(i);
        }
        return headers;
    }

    private String[] getSelectedColumnNames() {
        int[] columns = this.table.getSelectedColumns();
        if (columns.length == 0) {
            return null;
        }
        String[] headers = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            headers[i] = this.table.getColumnName(columns[i]);
        }
        return headers;
    }

    private double calcsum() {
        double sum = 0.0;
        int[] rows = this.table.getSelectedRows();
        int ix = rows.length;
        int[] columns = this.table.getSelectedColumns();
        int kx = columns.length;
        for (int k = 0; k < kx; ++k) {
            for (int i = 0; i < ix; ++i) {
                if (this.table.getValueAt(rows[i], columns[k]).getClass() != String.class) {
                    sum += ((Double)this.table.getValueAt(rows[i], columns[k])).doubleValue();
                    continue;
                }
                sum += 0.0;
            }
        }
        return sum;
    }

    private double calcmean() {
        double mean = 0.0;
        double sum = this.calcsum();
        int[] rows = this.table.getSelectedRows();
        int ix = rows.length;
        int[] columns = this.table.getSelectedColumns();
        int kx = columns.length;
        if (ix == 1) {
            mean = sum / (double)kx;
        }
        if (kx == 1) {
            mean = sum / (double)ix;
        }
        if (kx != 1 && ix != 1) {
            mean = sum / (double)(kx * ix);
        }
        return mean;
    }

    public String getPanelName() {
        return this.panelname;
    }

    public void setColumnNameArray(String[] names) {
        this.tmodel.setColumnNames(names);
    }

    public void updateGUI() {
        this.table.setModel(this.tmodel);
        this.scrollpane.setViewportView(this.table);
        this.updateShapeSelector();
        this.repaint();
    }

    public void makeTable() {
        this.table = new JTable(this.tmodel);
        this.tableHeader = this.table.getTableHeader();
        this.table.getTableHeader().setReorderingAllowed(false);
        HeaderHandler mouseListener = new HeaderHandler();
        this.tableHeader.addMouseListener(mouseListener);
        this.table.setAutoCreateRowSorter(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setDragEnabled(true);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(0);
        new ExcelAdapter(this.table);
    }

    public void createPanel() {
        this.setLayout(new BorderLayout(10, 10));
        JPanel controlpanel = new JPanel();
        JPanel helperpanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        controlpanel.setLayout(gbl);
        JPanel headerpanel = new JPanel();
        headerpanel.setLayout(new GridLayout(1, 2));
        this.useTemplateButton.setEnabled(true);
        this.useTemplateButton.setSelected(false);
        this.useTransposedButton.setEnabled(true);
        this.useTransposedButton.setSelected(false);
        this.scrollpane.setVerticalScrollBarPolicy(22);
        this.scrollpane.getVerticalScrollBar().setUnitIncrement(100);
        this.makeTable();
        GUIHelper.addGBComponent(controlpanel, gbl, this.plotButton, 0, 6, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(controlpanel, gbl, this.dataplotButton, 0, 7, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(controlpanel, gbl, this.useTemplateButton, 0, 8, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(controlpanel, gbl, this.useTransposedButton, 0, 9, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(controlpanel, gbl, this.savebutton, 0, 11, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(controlpanel, gbl, this.statButton, 0, 13, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(controlpanel, gbl, this.trendButton, 0, 14, 1, 1, 0.0, 0.0);
        if (this.updateShapeSelector()) {
            JButton joinMapButton = new JButton(this.joinMapAction);
            GUIHelper.addGBComponent(controlpanel, gbl, joinMapButton, 0, 16, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(controlpanel, gbl, this.shapeSelector, 0, 17, 1, 1, 0.0, 0.0);
        }
        this.statButton.addActionListener(this.statisticAction);
        this.trendButton.addActionListener(this.trendAction);
        this.savebutton.addActionListener(this.saveAction);
        this.plotButton.addActionListener(this.plotAction);
        this.dataplotButton.addActionListener(this.dataplotAction);
        this.stpButton.addActionListener(this.stpAction);
        this.closeButton.addActionListener(this.closeTabAction);
        headerpanel.add(this.titleLabel);
        headerpanel.add(this.headerlabel);
        helperpanel.add(controlpanel);
        this.add((Component)headerpanel, "North");
        this.add((Component)this.scrollpane, "Center");
        this.add((Component)helperpanel, "East");
    }

    private boolean updateShapeSelector() {
        String[] shapeNames = this.explorer.getWorkspace().getDataStoreIDs("shapefiledatastore");
        if (shapeNames != null && shapeNames.length > 0) {
            String defaultShapeName = shapeNames[0];
            DefaultComboBoxModel<String> shapeSelectorModel = new DefaultComboBoxModel<String>(shapeNames);
            shapeSelectorModel.setSelectedItem(defaultShapeName);
            this.shapeSelector.setModel(shapeSelectorModel);
            return true;
        }
        return false;
    }

    private class HeaderHandler
    extends MouseAdapter {
        int button = -1;
        int[] selectedColumns;
        int col_START = 1;
        int col_END = 0;

        private HeaderHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel tcm = h.getColumnModel();
            int viewCol = tcm.getColumnIndexAtX(e.getX());
            this.button = e.isShiftDown() ? 1 : (e.isControlDown() ? 2 : -1);
            block0 : switch (this.button) {
                case 1: {
                    this.col_END = JAMSSpreadSheet.this.table.getColumnModel().getColumn(viewCol).getModelIndex();
                    JAMSSpreadSheet.this.table.addColumnSelectionInterval(this.col_START, this.col_END);
                    break;
                }
                case 2: {
                    this.selectedColumns = JAMSSpreadSheet.this.table.getSelectedColumns();
                    this.col_END = JAMSSpreadSheet.this.table.getColumnModel().getColumn(viewCol).getModelIndex();
                    JAMSSpreadSheet.this.table.addColumnSelectionInterval(this.col_END, this.col_END);
                    for (int k = 0; k < this.selectedColumns.length; ++k) {
                        if (this.col_END != this.selectedColumns[k]) continue;
                        JAMSSpreadSheet.this.table.removeColumnSelectionInterval(this.col_END, this.col_END);
                        break block0;
                    }
                    break;
                }
                default: {
                    this.col_START = JAMSSpreadSheet.this.table.getColumnModel().getColumn(viewCol).getModelIndex();
                    JAMSSpreadSheet.this.table.setColumnSelectionInterval(this.col_START, this.col_START);
                }
            }
            JAMSSpreadSheet.this.table.setRowSelectionInterval(0, JAMSSpreadSheet.this.table.getRowCount() - 1);
            this.button = -1;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
            h.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
        }
    }

    public class TableHandler
    extends TransferHandler {
        JTable myTable;

        public TableHandler(JTable table) {
            this.myTable = table;
            table.setTransferHandler(this);
            table.setDragEnabled(true);
            table.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    e.consume();
                    JComponent c = (JComponent)e.getSource();
                    TransferHandler handler = c.getTransferHandler();
                    handler.exportAsDrag(c, e, 2);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c == this.myTable) {
                int[] rows = this.myTable.getSelectedRows();
                int[] cols = this.myTable.getSelectedColumns();
                TableModel model = this.myTable.getModel();
                StringBuffer t = new StringBuffer(rows.length * cols.length * 9);
                for (int i = 0; i < cols.length; ++i) {
                    t.append(model.getColumnName(cols[i]) + "\t");
                }
                t.append("\n");
                for (int j = 0; j < rows.length; ++j) {
                    for (int i = 0; i < cols.length; ++i) {
                        try {
                            if (i != cols.length - 1) {
                                t.append((Double)model.getValueAt(rows[j], cols[i]) + "\t");
                                continue;
                            }
                            t.append((Double)model.getValueAt(rows[j], cols[i]));
                            continue;
                        }
                        catch (Throwable ta) {
                            t.append("0.0");
                        }
                    }
                    if (j == rows.length - 1) continue;
                    t.append("\n");
                }
                return new TableDataTransferable(t.toString());
            }
            return super.createTransferable(c);
        }

        @Override
        public int getSourceActions(JComponent c) {
            if (this.myTable == c) {
                return 1;
            }
            return super.getSourceActions(c);
        }
    }

    public class ExcelAdapter
    implements ActionListener {
        private String rowstring;
        private String value;
        private Clipboard system;
        private StringSelection stsel;
        private JTable jTable1;

        public ExcelAdapter(JTable myJTable) {
            this.jTable1 = myJTable;
            KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
            KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
            this.jTable1.registerKeyboardAction(this, "Copy", copy, 0);
            this.jTable1.registerKeyboardAction(this, "Paste", paste, 0);
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
        }

        public JTable getJTable() {
            return this.jTable1;
        }

        public void setJTable(JTable jTable1) {
            this.jTable1 = jTable1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int j;
            if (e.getActionCommand().compareTo("Copy") == 0) {
                StringBuffer sbf = new StringBuffer();
                int numcols = this.jTable1.getSelectedColumnCount();
                int numrows = this.jTable1.getSelectedRowCount();
                int[] rowsselected = this.jTable1.getSelectedRows();
                int[] colsselected = this.jTable1.getSelectedColumns();
                if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
                    JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
                    return;
                }
                for (int j2 = 0; j2 < numcols; ++j2) {
                    sbf.append(this.jTable1.getColumnName(colsselected[j2]));
                    if (j2 >= numcols - 1) continue;
                    sbf.append("\t");
                }
                sbf.append("\n");
                for (int i = 0; i < numrows; ++i) {
                    for (j = 0; j < numcols; ++j) {
                        sbf.append(this.jTable1.getValueAt(rowsselected[i], colsselected[j]));
                        if (j >= numcols - 1) continue;
                        sbf.append("\t");
                    }
                    sbf.append("\n");
                }
                this.stsel = new StringSelection(sbf.toString());
                this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
                this.system.setContents(this.stsel, this.stsel);
            }
            if (e.getActionCommand().compareTo("Paste") == 0) {
                System.out.println("Trying to Paste");
                int startRow = this.jTable1.getSelectedRows()[0];
                int startCol = this.jTable1.getSelectedColumns()[0];
                try {
                    String trstring = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                    System.out.println("String is:" + trstring);
                    StringTokenizer st1 = new StringTokenizer(trstring, "\n");
                    int i = 0;
                    while (st1.hasMoreTokens()) {
                        this.rowstring = st1.nextToken();
                        StringTokenizer st2 = new StringTokenizer(this.rowstring, "\t");
                        j = 0;
                        while (st2.hasMoreTokens()) {
                            this.value = st2.nextToken();
                            if (startRow + i < this.jTable1.getRowCount() && startCol + j < this.jTable1.getColumnCount()) {
                                this.jTable1.setValueAt(this.value, startRow + i, startCol + j);
                            }
                            System.out.println("Putting " + this.value + "at row = " + startRow + i + " column = " + startCol + j);
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public class TableDataTransferable
    implements Transferable {
        String myValue;

        public TableDataTransferable(String value) {
            this.myValue = value;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == FLAVOR;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == FLAVOR) {
                return this.myValue;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    public class ProcessingException
    extends RuntimeException {
        ProcessingException(String message) {
            super(message);
        }

        ProcessingException(String message, Throwable t) {
            super(message, t);
        }
    }
}

