/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.gui;

import ccindex.explorer.dsproc.DataStatistic;
import jams.JAMS;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class StatisticDialogPanel
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private String[] fieldNames;
    private double[][] data;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JTable out_Table;
    private int returnStatus = 0;

    public StatisticDialogPanel(Frame parent, boolean modal, String[] theFieldNames, double[][] theData) {
        super(parent, modal);
        this.initComponents();
        this.fieldNames = theFieldNames;
        this.data = theData;
        this.setupComponents();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.out_Table = new JTable();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.setTitle("Stats");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StatisticDialogPanel.this.closeDialog(evt);
            }
        });
        this.out_Table.setColumnSelectionAllowed(true);
        this.jScrollPane1.setViewportView(this.out_Table);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatisticDialogPanel.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void setupComponents() {
        if (this.fieldNames == null) {
            return;
        }
        int numberOfFields = this.fieldNames.length;
        String statText = "";
        Object[][] statisticResult = null;
        HashMap<String, Double> oneResult = null;
        Object[] header = new String[numberOfFields + 1];
        header[0] = JAMS.i18n("KENNZIFFER");
        for (int i = 0; i < numberOfFields; ++i) {
            String fieldName = this.fieldNames[i];
            double[] colData = this.data[i];
            header[i + 1] = fieldName;
            DataStatistic dataStatistic = new DataStatistic(fieldName, colData);
            oneResult = dataStatistic.getResult();
            if (statisticResult == null) {
                statisticResult = new Object[oneResult.size()][numberOfFields + 1];
            }
            this.addToResult(oneResult, statisticResult, i + 1);
            statText = statText + dataStatistic.toString();
        }
        this.out_Table.setModel(new DefaultTableModel(statisticResult, header));
    }

    private void addToResult(HashMap<String, Double> oneResult, Object[][] statisticResult, int colNumber) {
        Set<String> keys = oneResult.keySet();
        int i = 0;
        for (String key : keys) {
            Double value = oneResult.get(key);
            statisticResult[i][0] = key;
            statisticResult[i][colNumber] = value;
            ++i;
        }
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

