/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.gui;

import ccindex.explorer.JAMSExplorer;
import ccindex.explorer.spreadsheet.STPConfigurator;
import jams.JAMS;
import jams.gui.PropertyDlg;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.io.XMLProcessor;
import jams.tools.StringTools;
import jams.workspace.InvalidWorkspaceException;
import jams.workspace.JAMSWorkspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;

public class ExplorerFrame
extends JFrame {
    protected static final int INOUT_PANE_WIDTH = 400;
    protected static final int INOUT_PANE_HEIGHT = 1000;
    protected static final int DIVIDER_WIDTH = 6;
    protected JFileChooser jfc = GUIHelper.getJFileChooser();
    protected WorkerDlg openWSDlg;
    protected Action openWSAction;
    protected Action openSTPAction;
    protected Action exitAction;
    protected Action editPrefsAction;
    protected Action sensitivityAnalysisAction;
    protected Action reloadWSAction;
    protected Action browseServerAction;
    protected Action closeCurrentPanelAction;
    protected JLabel statusLabel;
    protected JSplitPane mainSplitPane;
    protected JTabbedPane tPane;
    protected JAMSExplorer explorer;
    protected PropertyDlg propertyDlg;
    protected Document modelDoc = null;
    private JMenuItem saveEnsembleItem;

    public ExplorerFrame(JAMSExplorer explorer) {
        this.explorer = explorer;
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.createListener();
        this.exitAction = new AbstractAction(JAMS.i18n("CLOSE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.exit();
            }
        };
        this.openWSAction = new AbstractAction(JAMS.i18n("OPEN_WORKSPACE...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.open();
            }
        };
        this.editPrefsAction = new AbstractAction(JAMS.i18n("EDIT_PREFERENCES...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.propertyDlg.setProperties(ExplorerFrame.this.explorer.getProperties());
                ExplorerFrame.this.propertyDlg.setVisible(true);
                if (ExplorerFrame.this.propertyDlg.getResult() == 1) {
                    ExplorerFrame.this.propertyDlg.validateProperties();
                }
            }
        };
        this.openSTPAction = new AbstractAction(JAMS.i18n("STACKED_TIME_PLOT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                STPConfigurator stp = new STPConfigurator(ExplorerFrame.this.explorer);
            }
        };
        this.reloadWSAction = new AbstractAction(JAMS.i18n("RELOAD_WORKSPACE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.update();
            }
        };
        this.closeCurrentPanelAction = new AbstractAction(JAMS.i18n("Close_Current_Panel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplorerFrame.this.explorer.getDisplayManager().removeDisplay(ExplorerFrame.this.tPane.getSelectedComponent());
            }
        };
        this.update();
        this.propertyDlg = new PropertyDlg((Frame)this, this.explorer.getProperties());
        this.openWSDlg = new WorkerDlg((Window)this, JAMS.i18n("OPENING_WORKSPACE"));
        this.setTitle(JAMSExplorer.APP_TITLE);
        this.jfc.setFileSelectionMode(1);
        this.tPane = new JTabbedPane();
        this.mainSplitPane = new JSplitPane();
        JSplitPane inoutSplitPane = new JSplitPane();
        this.mainSplitPane.setAutoscrolls(true);
        this.mainSplitPane.setContinuousLayout(true);
        this.mainSplitPane.setLeftComponent(inoutSplitPane);
        this.mainSplitPane.setRightComponent(this.tPane);
        this.mainSplitPane.setDividerLocation(400);
        this.mainSplitPane.setDividerSize(6);
        this.mainSplitPane.setOneTouchExpandable(false);
        inoutSplitPane.setAutoscrolls(true);
        inoutSplitPane.setContinuousLayout(true);
        inoutSplitPane.setLeftComponent(this.explorer.getDisplayManager().getTreePanel());
        inoutSplitPane.setRightComponent(this.explorer.getDisplayManager().getInputDSInfoPanel());
        inoutSplitPane.setOrientation(0);
        inoutSplitPane.setDividerLocation(1000);
        inoutSplitPane.setDividerSize(6);
        inoutSplitPane.setOneTouchExpandable(false);
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        JToolBar toolBar = new JToolBar();
        JButton wsOpenButton = new JButton(this.openWSAction);
        wsOpenButton.setText("");
        wsOpenButton.setToolTipText((String)this.openWSAction.getValue("Name"));
        wsOpenButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelOpen.png")));
        toolBar.add(wsOpenButton);
        JButton reloadWSButton = new JButton(this.reloadWSAction);
        reloadWSButton.setText("");
        reloadWSButton.setToolTipText((String)this.reloadWSAction.getValue("Name"));
        reloadWSButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Reload.png")));
        toolBar.add(reloadWSButton);
        JButton closeCurrentPanelButton = new JButton(this.closeCurrentPanelAction);
        closeCurrentPanelButton.setText("");
        closeCurrentPanelButton.setToolTipText((String)this.closeCurrentPanelAction.getValue("Name"));
        closeCurrentPanelButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/close.png")));
        toolBar.add(closeCurrentPanelButton);
        JButton stpButton = new JButton(this.openSTPAction);
        toolBar = this.processToolBarHook(toolBar);
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new FlowLayout(0, 0, 0));
        toolBarPanel.add(toolBar);
        this.getContentPane().add((Component)toolBarPanel, "North");
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createEtchedBorder());
        statusPanel.setPreferredSize(new Dimension(14, 20));
        this.statusLabel = new JLabel();
        this.statusLabel.setText(JAMS.i18n("DATA_EXPLORER"));
        statusPanel.add((Component)this.statusLabel, "Center");
        this.getContentPane().add((Component)statusPanel, "South");
        JMenuBar mainMenu = new JMenuBar();
        JMenu fileMenu = new JMenu(JAMS.i18n("FILE"));
        mainMenu.add(fileMenu);
        if (this.explorer.isStandAlone()) {
            JMenu prefsMenu = new JMenu(JAMS.i18n("PREFERENCES"));
            JMenuItem editPrefsItem = new JMenuItem(this.editPrefsAction);
            prefsMenu.add(editPrefsItem);
            mainMenu.add(prefsMenu);
        }
        JMenu plotMenu = new JMenu(JAMS.i18n("PLOT"));
        mainMenu.add(plotMenu);
        JMenuItem openWSItem = new JMenuItem(this.openWSAction);
        openWSItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        fileMenu.add(openWSItem);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem(this.exitAction);
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        fileMenu.add(exitItem);
        JMenuItem stpItem = new JMenuItem(this.openSTPAction);
        plotMenu.add(stpItem);
        this.setJMenuBar(mainMenu);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setMinimumSize(new Dimension(1200, 1000));
    }

    protected JToolBar processToolBarHook(JToolBar toolBar) {
        return toolBar;
    }

    public void open(File workspaceFile) throws InvalidWorkspaceException {
        String[] libs = StringTools.toArray(this.explorer.getProperties().getProperty("libs", ""), ";");
        JAMSWorkspace workspace = new JAMSWorkspace(workspaceFile, this.explorer.getRuntime(), false);
        workspace.init();
        this.explorer.getDisplayManager().removeAllDisplays();
        this.explorer.setWorkspace(workspace);
        this.update();
    }

    protected void open() {
        int result = this.jfc.showOpenDialog(this);
        if (result == 0) {
            this.openWSDlg.setTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExplorerFrame.this.open(ExplorerFrame.this.jfc.getSelectedFile());
                    }
                    catch (InvalidWorkspaceException ex) {
                        ExplorerFrame.this.explorer.getRuntime().handle(ex);
                    }
                }
            });
            this.openWSDlg.execute();
        }
    }

    public void reset() {
        this.explorer.setWorkspace(null);
        this.update();
    }

    public void update() {
        JAMSWorkspace workspace = this.explorer.getWorkspace();
        if (workspace == null) {
            this.reloadWSAction.setEnabled(false);
        } else {
            workspace.updateDataStores();
            this.jfc.setSelectedFile(workspace.getDirectory());
            this.setTitle(JAMSExplorer.APP_TITLE + " [" + workspace.getDirectory().toString() + "]");
            this.reloadWSAction.setEnabled(true);
            this.explorer.getDisplayManager().getTreePanel().update();
            this.mainSplitPane.setDividerLocation(400);
        }
    }

    protected void setWorkSpace2Model() {
        JAMSWorkspace workspace = this.explorer.getWorkspace();
        try {
            String directoryName = workspace.getDirectory().getCanonicalPath();
            XMLProcessor.setWorkspacePath(this.modelDoc, directoryName);
        }
        catch (Exception e) {
            this.explorer.getRuntime().handle(e);
        }
    }

    protected void createListener() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ExplorerFrame.this.exit();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public JTabbedPane getTPane() {
        return this.tPane;
    }

    protected void exit() {
        for (Window window : this.explorer.getChildWindows()) {
            window.dispose();
        }
        this.setVisible(false);
        this.dispose();
        this.explorer.exit();
    }
}

