/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.ensembles.gui;

import ccindex.explorer.ensembles.gui.AbstractClimateDataTab;
import ccindex.explorer.ensembles.gui.EnsembleControlPanel;
import ccindex.explorer.ensembles.implementation.ClimateEnsembleProcessor;
import ccindex.explorer.ensembles.implementation.ClimateModel;
import jams.aggregators.Aggregator;
import jams.aggregators.DoubleAggregator;
import jams.data.Attribute;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ClimateDataOverviewTab
extends AbstractClimateDataTab {
    static final Logger logger = Logger.getLogger(ClimateDataOverviewTab.class.getName());
    ClimateEnsembleProcessor proc;
    JTable table;

    public ClimateDataOverviewTab(String name) {
        super(name);
        EnsembleControlPanel.registerLogHandler(logger);
        this.proc = null;
        this.table = new JTable();
        JScrollPane pane = new JScrollPane(this.table, 20, 32);
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
    }

    @Override
    public void calculate() {
        logger.entering(this.getClass().getName(), "calculate()");
        this.isChanged = false;
        if (this.output == null) {
            this.table.setModel(new DefaultTableModel(1, 1));
        }
        this.proc = new ClimateEnsembleProcessor(this.ensemble, this.output);
        this.proc.init();
        try {
            Attribute.Calendar[] dates = this.proc.getTimeDomain();
            int offset = 7;
            Object[] columnNames = new String[this.n + offset];
            columnNames[0] = "Date";
            columnNames[1] = "Mean";
            columnNames[2] = "Median";
            columnNames[3] = "Q5";
            columnNames[4] = "Q95";
            columnNames[5] = "Spannweite";
            columnNames[6] = "Varianz";
            for (int i = offset; i < this.n + offset; ++i) {
                columnNames[i] = ((ClimateModel)this.ensemble.getModel(i - offset)).toString();
            }
            DefaultTableModel tableModel = new DefaultTableModel(columnNames, dates.length){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }

                public Class getColumnClass(int col) {
                    return col == 0 ? String.class : Double.class;
                }
            };
            for (int i = 0; i < dates.length; ++i) {
                tableModel.setValueAt(dates[i], i, 0);
            }
            this.table.setAutoResizeMode(0);
            DoubleAggregator avgAggregator = DoubleAggregator.create(Aggregator.AggregationMode.AVERAGE);
            DoubleAggregator varAggregator = DoubleAggregator.create(Aggregator.AggregationMode.VARIANCE);
            DoubleAggregator.MedianAggregator medianAggregator = (DoubleAggregator.MedianAggregator)DoubleAggregator.create(Aggregator.AggregationMode.MEDIAN);
            double[][] result = this.proc.getSpatialMean();
            for (int i = 0; i < dates.length; ++i) {
                tableModel.setValueAt(dates[i], i, 0);
                avgAggregator.init();
                medianAggregator.init();
                varAggregator.init();
                for (int j = 0; j < this.n; ++j) {
                    avgAggregator.consider(result[j][i]);
                    medianAggregator.consider(result[j][i]);
                    varAggregator.consider(result[j][i]);
                    tableModel.setValueAt(result[j][i], i, j + offset);
                }
                avgAggregator.finish();
                medianAggregator.finish();
                varAggregator.finish();
                tableModel.setValueAt(avgAggregator.get(), i, 1);
                tableModel.setValueAt(medianAggregator.get(), i, 2);
                tableModel.setValueAt(medianAggregator.getQuantile(0.05), i, 3);
                tableModel.setValueAt(medianAggregator.getQuantile(0.95), i, 4);
                double spannweite = medianAggregator.getQuantile(1.0) - medianAggregator.getQuantile(0.0);
                tableModel.setValueAt(spannweite, i, 5);
                tableModel.setValueAt(varAggregator.get(), i, 6);
            }
            this.table.setModel(tableModel);
            this.table.setDefaultRenderer(Double.TYPE, new DoubleRenderer());
            this.table.setDefaultRenderer(Double.class, new DoubleRenderer());
            Enumeration<TableColumn> e = this.table.getColumnModel().getColumns();
            if (e.hasMoreElements()) {
                TableColumn col = e.nextElement();
                col.setMinWidth(150);
            }
            while (e.hasMoreElements()) {
                TableColumn col = e.nextElement();
                col.setMinWidth(100);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Sorry, an error occured during aggregation!", e);
        }
        logger.exiting(this.getClass().getName(), "calculate()");
    }

    public class DoubleRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : String.format(Locale.ENGLISH, "%.2f", value));
        }
    }
}

